/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.storage.dledger.protocol;

import java.util.HashMap;
import java.util.Map;

public enum DLedgerResponseCode {
    UNKNOWN(-1, ""),
    SUCCESS(200, ""),
    TIMEOUT(300, ""),
    METADATA_ERROR(301, ""),
    NETWORK_ERROR(302, ""),
    UNSUPPORTED(303, ""),
    UNKNOWN_GROUP(400, ""),
    UNKNOWN_MEMBER(401, ""),
    UNEXPECTED_MEMBER(402, ""),
    EXPIRED_TERM(403, ""),
    NOT_LEADER(404, ""),
    NOT_FOLLOWER(405, ""),
    INCONSISTENT_STATE(406, ""),
    INCONSISTENT_TERM(407, ""),
    INCONSISTENT_INDEX(408, ""),
    INCONSISTENT_LEADER(409, ""),
    INDEX_OUT_OF_RANGE(410, ""),
    UNEXPECTED_ARGUMENT(411, ""),
    REPEATED_REQUEST(412, ""),
    REPEATED_PUSH(413, ""),
    DISK_ERROR(414, ""),
    DISK_FULL(415, ""),
    TERM_NOT_READY(416, ""),
    INTERNAL_ERROR(500, ""),
    TERM_CHANGED(501, ""),
    WAIT_QUORUM_ACK_TIMEOUT(502, ""),
    LEADER_PENDING_FULL(503, ""),
    ILLEGAL_MEMBER_STATE(504, ""),
    LEADER_NOT_READY(505, "");

    private static Map<Integer, DLedgerResponseCode> codeMap;
    private int code;
    private String desc;

    private DLedgerResponseCode(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static DLedgerResponseCode valueOf(int code) {
        DLedgerResponseCode tmp = codeMap.get(code);
        if (tmp != null) {
            return tmp;
        }
        return UNKNOWN;
    }

    public int getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    public String toString() {
        return String.format("[code=%d,name=%s,desc=%s]", this.code, this.name(), this.desc);
    }

    static {
        codeMap = new HashMap<Integer, DLedgerResponseCode>();
        for (DLedgerResponseCode responseCode : DLedgerResponseCode.values()) {
            codeMap.put(responseCode.code, responseCode);
        }
    }
}

