/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.logging.otlp.internal.logs;

import io.opentelemetry.exporter.internal.marshal.Marshaler;
import io.opentelemetry.exporter.internal.otlp.logs.LogsRequestMarshaler;
import io.opentelemetry.exporter.internal.otlp.logs.ResourceLogsMarshaler;
import io.opentelemetry.exporter.logging.otlp.internal.logs.OtlpStdoutLogRecordExporterBuilder;
import io.opentelemetry.exporter.logging.otlp.internal.writer.JsonWriter;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.logs.data.LogRecordData;
import io.opentelemetry.sdk.logs.export.LogRecordExporter;
import java.util.Collection;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class OtlpStdoutLogRecordExporter
implements LogRecordExporter {
    private static final Logger LOGGER = Logger.getLogger(OtlpStdoutLogRecordExporter.class.getName());
    private final AtomicBoolean isShutdown = new AtomicBoolean();
    private final Logger logger;
    private final JsonWriter jsonWriter;
    private final boolean wrapperJsonObject;

    OtlpStdoutLogRecordExporter(Logger logger, JsonWriter jsonWriter, boolean wrapperJsonObject) {
        this.logger = logger;
        this.jsonWriter = jsonWriter;
        this.wrapperJsonObject = wrapperJsonObject;
    }

    public static OtlpStdoutLogRecordExporterBuilder builder() {
        return new OtlpStdoutLogRecordExporterBuilder(LOGGER).setOutput(System.out);
    }

    public CompletableResultCode export(Collection<LogRecordData> logs) {
        if (this.isShutdown.get()) {
            return CompletableResultCode.ofFailure();
        }
        if (this.wrapperJsonObject) {
            LogsRequestMarshaler request = LogsRequestMarshaler.create(logs);
            return this.jsonWriter.write((Marshaler)request);
        }
        for (ResourceLogsMarshaler resourceLogs : ResourceLogsMarshaler.create(logs)) {
            CompletableResultCode resultCode = this.jsonWriter.write((Marshaler)resourceLogs);
            if (resultCode.isSuccess()) continue;
            return resultCode;
        }
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode flush() {
        return this.jsonWriter.flush();
    }

    public CompletableResultCode shutdown() {
        if (!this.isShutdown.compareAndSet(false, true)) {
            this.logger.log(Level.INFO, "Calling shutdown() multiple times.");
        } else {
            this.jsonWriter.close();
        }
        return CompletableResultCode.ofSuccess();
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(", ", "OtlpStdoutLogRecordExporter{", "}");
        joiner.add("jsonWriter=" + this.jsonWriter);
        joiner.add("wrapperJsonObject=" + this.wrapperJsonObject);
        return joiner.toString();
    }
}

