/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.logging.otlp.internal.metrics;

import io.opentelemetry.exporter.internal.marshal.Marshaler;
import io.opentelemetry.exporter.internal.otlp.metrics.MetricsRequestMarshaler;
import io.opentelemetry.exporter.internal.otlp.metrics.ResourceMetricsMarshaler;
import io.opentelemetry.exporter.logging.otlp.internal.metrics.OtlpStdoutMetricExporterBuilder;
import io.opentelemetry.exporter.logging.otlp.internal.writer.JsonWriter;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.metrics.Aggregation;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.export.AggregationTemporalitySelector;
import io.opentelemetry.sdk.metrics.export.DefaultAggregationSelector;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import java.util.Collection;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class OtlpStdoutMetricExporter
implements MetricExporter {
    private static final Logger LOGGER = Logger.getLogger(OtlpStdoutMetricExporter.class.getName());
    private final AtomicBoolean isShutdown = new AtomicBoolean();
    private final Logger logger;
    private final JsonWriter jsonWriter;
    private final boolean wrapperJsonObject;
    private final AggregationTemporalitySelector aggregationTemporalitySelector;
    private final DefaultAggregationSelector defaultAggregationSelector;

    OtlpStdoutMetricExporter(Logger logger, JsonWriter jsonWriter, boolean wrapperJsonObject, AggregationTemporalitySelector aggregationTemporalitySelector, DefaultAggregationSelector defaultAggregationSelector) {
        this.logger = logger;
        this.jsonWriter = jsonWriter;
        this.wrapperJsonObject = wrapperJsonObject;
        this.aggregationTemporalitySelector = aggregationTemporalitySelector;
        this.defaultAggregationSelector = defaultAggregationSelector;
    }

    public static OtlpStdoutMetricExporterBuilder builder() {
        return new OtlpStdoutMetricExporterBuilder(LOGGER).setOutput(System.out);
    }

    public AggregationTemporality getAggregationTemporality(InstrumentType instrumentType) {
        return this.aggregationTemporalitySelector.getAggregationTemporality(instrumentType);
    }

    public Aggregation getDefaultAggregation(InstrumentType instrumentType) {
        return this.defaultAggregationSelector.getDefaultAggregation(instrumentType);
    }

    public CompletableResultCode export(Collection<MetricData> metrics) {
        if (this.isShutdown.get()) {
            return CompletableResultCode.ofFailure();
        }
        if (this.wrapperJsonObject) {
            MetricsRequestMarshaler request = MetricsRequestMarshaler.create(metrics);
            return this.jsonWriter.write((Marshaler)request);
        }
        for (ResourceMetricsMarshaler resourceMetrics : ResourceMetricsMarshaler.create(metrics)) {
            CompletableResultCode resultCode = this.jsonWriter.write((Marshaler)resourceMetrics);
            if (resultCode.isSuccess()) continue;
            return resultCode;
        }
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode flush() {
        return this.jsonWriter.flush();
    }

    public CompletableResultCode shutdown() {
        if (!this.isShutdown.compareAndSet(false, true)) {
            this.logger.log(Level.INFO, "Calling shutdown() multiple times.");
        } else {
            this.jsonWriter.close();
        }
        return CompletableResultCode.ofSuccess();
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(", ", "OtlpStdoutMetricExporter{", "}");
        joiner.add("jsonWriter=" + this.jsonWriter);
        joiner.add("wrapperJsonObject=" + this.wrapperJsonObject);
        return joiner.toString();
    }
}

