/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.logging.otlp.internal.traces;

import io.opentelemetry.exporter.internal.marshal.Marshaler;
import io.opentelemetry.exporter.internal.otlp.traces.ResourceSpansMarshaler;
import io.opentelemetry.exporter.internal.otlp.traces.TraceRequestMarshaler;
import io.opentelemetry.exporter.logging.otlp.internal.traces.OtlpStdoutSpanExporterBuilder;
import io.opentelemetry.exporter.logging.otlp.internal.writer.JsonWriter;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.Collection;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class OtlpStdoutSpanExporter
implements SpanExporter {
    private static final Logger LOGGER = Logger.getLogger(OtlpStdoutSpanExporter.class.getName());
    private final AtomicBoolean isShutdown = new AtomicBoolean();
    private final Logger logger;
    private final JsonWriter jsonWriter;
    private final boolean wrapperJsonObject;

    OtlpStdoutSpanExporter(Logger logger, JsonWriter jsonWriter, boolean wrapperJsonObject) {
        this.logger = logger;
        this.jsonWriter = jsonWriter;
        this.wrapperJsonObject = wrapperJsonObject;
    }

    public static OtlpStdoutSpanExporterBuilder builder() {
        return new OtlpStdoutSpanExporterBuilder(LOGGER).setOutput(System.out);
    }

    public CompletableResultCode export(Collection<SpanData> spans) {
        if (this.isShutdown.get()) {
            return CompletableResultCode.ofFailure();
        }
        if (this.wrapperJsonObject) {
            TraceRequestMarshaler request = TraceRequestMarshaler.create(spans);
            return this.jsonWriter.write((Marshaler)request);
        }
        for (ResourceSpansMarshaler resourceSpans : ResourceSpansMarshaler.create(spans)) {
            CompletableResultCode resultCode = this.jsonWriter.write((Marshaler)resourceSpans);
            if (resultCode.isSuccess()) continue;
            return resultCode;
        }
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode flush() {
        return this.jsonWriter.flush();
    }

    public CompletableResultCode shutdown() {
        if (!this.isShutdown.compareAndSet(false, true)) {
            this.logger.log(Level.INFO, "Calling shutdown() multiple times.");
        } else {
            this.jsonWriter.close();
        }
        return CompletableResultCode.ofSuccess();
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(", ", "OtlpStdoutSpanExporter{", "}");
        joiner.add("jsonWriter=" + this.jsonWriter);
        joiner.add("wrapperJsonObject=" + this.wrapperJsonObject);
        return joiner.toString();
    }
}

