/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.impl;

import com.github.kristofa.brave.Brave;
import com.github.kristofa.brave.ClientTracer;
import com.github.kristofa.brave.ServerTracer;
import com.github.kristofa.brave.SpanId;
import io.opentracing.impl.AbstractSpan;
import io.opentracing.impl.BraveSpanContext;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

final class BraveSpan
extends AbstractSpan
implements BraveSpanContext {
    final SpanId spanId;
    final Optional<BraveSpanContext> parent;
    final Optional<ServerTracer> serverTracer;
    private final Brave brave;
    private Optional<ClientTracer> clientTracer = Optional.empty();

    public static BraveSpan create(Brave brave, String operationName, Optional<BraveSpanContext> parent, Instant start, Optional<ServerTracer> serverTracer) {
        return new BraveSpan(brave, operationName, parent, start, serverTracer);
    }

    private BraveSpan(Brave brave, String operationName, Optional<BraveSpanContext> parent, Instant start, Optional<ServerTracer> serverTracer) {
        super(operationName, start);
        this.brave = brave;
        this.parent = parent;
        this.serverTracer = serverTracer;
        this.spanId = brave.localTracer().startNewSpan("jvm", operationName, TimeUnit.SECONDS.toMicros(start.getEpochSecond()) + TimeUnit.NANOSECONDS.toMicros(start.getNano()));
    }

    public void finish() {
        super.finish();
        this.brave.localTracer().finishSpan();
        if (this.clientTracer.isPresent()) {
            this.clientTracer.get().setClientReceived();
        }
        if (this.serverTracer.isPresent()) {
            this.serverTracer.get().setServerSend();
        }
    }

    void setClientTracer(ClientTracer clientTracer) {
        this.clientTracer = Optional.of(clientTracer);
    }

    @Override
    public long getContextTraceId() {
        return this.spanId.traceId;
    }

    @Override
    public long getContextSpanId() {
        return this.spanId.spanId;
    }

    @Override
    public Long getContextParentSpanId() {
        return this.spanId.parentId;
    }
}

