/*
 * Decompiled with CFR 0.152.
 */
package brave.opentracing;

import brave.Span;
import brave.opentracing.BraveSpanContext;
import io.opentracing.SpanContext;
import java.util.Iterator;
import java.util.Map;

public final class BraveSpan
implements io.opentracing.Span {
    private final Span delegate;
    private final SpanContext context;

    static BraveSpan wrap(Span span) {
        if (span == null) {
            throw new NullPointerException("span == null");
        }
        return new BraveSpan(span);
    }

    public final Span unwrap() {
        return this.delegate;
    }

    private BraveSpan(Span delegate) {
        this.delegate = delegate;
        this.context = BraveSpanContext.wrap(delegate.context());
    }

    public SpanContext context() {
        return this.context;
    }

    public void finish() {
        this.delegate.finish();
    }

    public void finish(long finishMicros) {
        this.delegate.finish(finishMicros);
    }

    public void close() {
        this.delegate.finish();
    }

    public io.opentracing.Span setTag(String key, String value) {
        this.delegate.tag(key, value);
        return this;
    }

    public io.opentracing.Span setTag(String key, boolean value) {
        return this.setTag(key, Boolean.toString(value));
    }

    public io.opentracing.Span setTag(String key, Number value) {
        return this.setTag(key, value.toString());
    }

    public io.opentracing.Span log(Map<String, ?> fields) {
        if (fields.isEmpty()) {
            return this;
        }
        return this.log(BraveSpan.toAnnotation(fields));
    }

    public io.opentracing.Span log(long timestampMicroseconds, Map<String, ?> fields) {
        if (fields.isEmpty()) {
            return this;
        }
        return this.log(timestampMicroseconds, BraveSpan.toAnnotation(fields));
    }

    static String toAnnotation(Map<String, ?> fields) {
        Object event = fields.get("event");
        if (event != null && fields.size() == 1) {
            return event.toString();
        }
        return BraveSpan.joinOnEqualsSpace(fields);
    }

    static String joinOnEqualsSpace(Map<String, ?> fields) {
        if (fields.isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        Iterator<Map.Entry<String, ?>> i = fields.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<String, ?> next = i.next();
            result.append(next.getKey()).append('=').append(next.getValue());
            if (!i.hasNext()) continue;
            result.append(' ');
        }
        return result.toString();
    }

    public io.opentracing.Span log(String event) {
        this.delegate.annotate(event);
        return this;
    }

    public io.opentracing.Span log(long timestampMicroseconds, String event) {
        this.delegate.annotate(timestampMicroseconds, event);
        return this;
    }

    public io.opentracing.Span log(String eventName, Object ignored) {
        return this.log(eventName);
    }

    public io.opentracing.Span log(long timestampMicroseconds, String eventName, Object ignored) {
        return this.log(timestampMicroseconds, eventName);
    }

    public io.opentracing.Span setBaggageItem(String key, String value) {
        return this;
    }

    public String getBaggageItem(String key) {
        return null;
    }

    public io.opentracing.Span setOperationName(String operationName) {
        this.delegate.name(operationName);
        return this;
    }
}

