/*
 * Decompiled with CFR 0.152.
 */
package brave.opentracing;

import brave.Span;
import brave.Tracer;
import brave.opentracing.BraveSpan;
import brave.opentracing.BraveSpanContext;
import brave.propagation.TraceContext;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public final class BraveSpanBuilder
implements Tracer.SpanBuilder {
    private final Tracer brave;
    private final Map<String, String> tags = new LinkedHashMap<String, String>();
    private String operationName;
    private long timestamp;
    private TraceContext parent;

    BraveSpanBuilder(Tracer brave, String operationName) {
        this.brave = brave;
        this.operationName = operationName;
    }

    public Tracer.SpanBuilder asChildOf(SpanContext parent) {
        return this.addReference("child_of", parent);
    }

    public Tracer.SpanBuilder asChildOf(io.opentracing.Span parent) {
        return this.asChildOf(parent.context());
    }

    public Tracer.SpanBuilder addReference(String referenceType, SpanContext referencedContext) {
        if (this.parent != null) {
            return this;
        }
        if ("child_of".equals(referenceType) || "follows_from".equals(referenceType)) {
            this.parent = ((BraveSpanContext)referencedContext).unwrap();
        }
        return this;
    }

    public Tracer.SpanBuilder withTag(String key, String value) {
        this.tags.put(key, value);
        return this;
    }

    public Tracer.SpanBuilder withTag(String key, boolean value) {
        return this.withTag(key, Boolean.toString(value));
    }

    public Tracer.SpanBuilder withTag(String key, Number value) {
        return this.withTag(key, value.toString());
    }

    public Tracer.SpanBuilder withStartTimestamp(long microseconds) {
        this.timestamp = microseconds;
        return this;
    }

    public BraveSpan start() {
        Span span;
        Span span2 = span = this.parent == null ? this.brave.newTrace() : this.brave.newChild(this.parent);
        if (this.operationName != null) {
            span.name(this.operationName);
        }
        for (Map.Entry<String, String> tag : this.tags.entrySet()) {
            span.tag(tag.getKey(), tag.getValue());
        }
        Span result = this.timestamp != 0L ? span.start(this.timestamp) : span.start();
        return BraveSpan.wrap(result);
    }

    public Iterable<Map.Entry<String, String>> baggageItems() {
        return Collections.EMPTY_SET;
    }
}

