/*
 * Decompiled with CFR 0.152.
 */
package brave.opentracing;

import brave.Tracer;
import brave.opentracing.BraveSpanBuilder;
import brave.opentracing.BraveSpanContext;
import brave.opentracing.BraveTracer$$Lambda$1;
import brave.opentracing.BraveTracer$$Lambda$4;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class BraveTracer
implements io.opentracing.Tracer {
    static final List<String> PROPAGATION_KEYS = Propagation.B3_STRING.keys();
    static final TraceContext.Injector<TextMap> INJECTOR = Propagation.B3_STRING.injector(BraveTracer$$Lambda$1.lambdaFactory$());
    static final TraceContext.Extractor<TextMapView> EXTRACTOR = Propagation.B3_STRING.extractor(BraveTracer$$Lambda$4.lambdaFactory$());
    static final Set<String> FIELDS_LOWER_CASE = BraveTracer.buildHashSetLowerCase(PROPAGATION_KEYS);
    private final Tracer brave4;

    public static BraveTracer wrap(Tracer brave4) {
        if (brave4 == null) {
            throw new NullPointerException("brave tracer == null");
        }
        return new BraveTracer(brave4);
    }

    private BraveTracer(Tracer brave4) {
        this.brave4 = brave4;
    }

    public Tracer.SpanBuilder buildSpan(String operationName) {
        return new BraveSpanBuilder(this.brave4, operationName);
    }

    public <C> void inject(SpanContext spanContext, Format<C> format, C carrier) {
        if (format != Format.Builtin.HTTP_HEADERS && format != Format.Builtin.TEXT_MAP) {
            throw new UnsupportedOperationException(format.toString() + " != Format.Builtin.HTTP_HEADERS or Format.Builtin.TEXT_MAP");
        }
        TraceContext traceContext = ((BraveSpanContext)spanContext).unwrap();
        INJECTOR.inject(traceContext, (Object)((TextMap)carrier));
    }

    public <C> SpanContext extract(Format<C> format, C carrier) {
        if (format != Format.Builtin.HTTP_HEADERS && format != Format.Builtin.TEXT_MAP) {
            throw new UnsupportedOperationException(format.toString() + " != Format.Builtin.HTTP_HEADERS or Format.Builtin.TEXT_MAP");
        }
        TraceContextOrSamplingFlags result = EXTRACTOR.extract((Object)new TextMapView(FIELDS_LOWER_CASE, (TextMap)carrier));
        TraceContext context = result.context() != null ? result.context().toBuilder().shared(true).build() : this.brave4.newTrace(result.samplingFlags()).context();
        return BraveSpanContext.wrap(context);
    }

    static Set<String> buildHashSetLowerCase(List<String> fields) {
        HashSet<String> lcSet = new HashSet<String>();
        for (String f : fields) {
            lcSet.add(f.toLowerCase());
        }
        return lcSet;
    }

    static final class TextMapView {
        final Iterator<Map.Entry<String, String>> input;
        final Map<String, String> cache = new LinkedHashMap<String, String>();
        final Set<String> fields;

        TextMapView(Set<String> fields, TextMap input) {
            this.input = input.iterator();
            this.fields = fields;
        }

        String get(String key) {
            while (this.input.hasNext()) {
                Map.Entry<String, String> next = this.input.next();
                String inputKey = next.getKey().toLowerCase();
                if (!this.fields.contains(inputKey)) continue;
                this.cache.put(inputKey, next.getValue());
            }
            return this.cache.get(key.toLowerCase());
        }
    }
}

