/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.impl;

import io.opentracing.Tracer;
import io.opentracing.impl.AbstractSpanBuilder;
import io.opentracing.impl.AbstractTracer;
import io.opentracing.propagation.Extractor;
import io.opentracing.propagation.TextMap;
import java.util.Map;

final class TextMapExtractorImpl
implements Extractor<TextMap> {
    private final AbstractTracer tracer;

    TextMapExtractorImpl(AbstractTracer tracer) {
        this.tracer = tracer;
    }

    @Override
    public Tracer.SpanBuilder extract(TextMap carrier) {
        AbstractSpanBuilder builder = this.tracer.createSpanBuilder("extracted");
        for (Map.Entry entry : carrier) {
            if (builder.isTraceState((String)entry.getKey(), entry.getValue())) {
                builder.withStateItem((String)entry.getKey(), entry.getValue());
                continue;
            }
            builder.withBaggageItem((String)entry.getKey(), (String)entry.getValue());
        }
        return builder;
    }
}

