/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.impl;

import io.opentracing.SpanContext;
import io.opentracing.impl.AbstractSpan;
import io.opentracing.impl.AbstractTracer;
import io.opentracing.propagation.Injector;
import io.opentracing.propagation.TextMap;
import java.util.Map;

final class TextMapInjectorImpl
implements Injector<TextMap> {
    private final AbstractTracer tracer;
    private boolean baggageEnabled = AbstractTracer.BAGGAGE_ENABLED;

    TextMapInjectorImpl(AbstractTracer tracer) {
        this.tracer = tracer;
    }

    @Override
    public void inject(SpanContext spanContext, TextMap carrier) {
        for (Map.Entry<String, Object> entry : this.tracer.getTraceState(spanContext).entrySet()) {
            carrier.put(entry.getKey(), entry.getValue().toString());
        }
        if (this.baggageEnabled) {
            for (Map.Entry<String, Object> entry : ((AbstractSpan)spanContext).baggageItems()) {
                carrier.put(entry.getKey(), (String)entry.getValue());
            }
        }
    }

    void setBaggageEnabled(boolean baggageEnabled) {
        this.baggageEnabled = baggageEnabled;
    }
}

