/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty;

import io.netty.channel.ChannelHandler;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import java.net.InetSocketAddress;
import java.util.function.Consumer;
import reactor.core.publisher.Flux;
import reactor.ipc.netty.ByteBufFlux;
import reactor.ipc.netty.NettyContext;
import reactor.ipc.netty.ReactorNetty;

public interface NettyInbound {
    default public <T> Attribute<T> attr(AttributeKey<T> key) {
        return this.context().channel().attr(key);
    }

    public NettyContext context();

    default public NettyInbound context(Consumer<NettyContext> contextCallback) {
        contextCallback.accept(this.context());
        return this;
    }

    default public NettyInbound onReadIdle(long idleTimeout, Runnable onReadIdle) {
        this.context().removeHandler("reactor.left.onChannelReadIdle");
        this.context().addHandlerFirst("reactor.left.onChannelReadIdle", (ChannelHandler)new ReactorNetty.InboundIdleStateHandler(idleTimeout, onReadIdle));
        return this;
    }

    default public ByteBufFlux receive() {
        return ByteBufFlux.fromInbound(this.receiveObject(), this.context().channel().alloc());
    }

    public Flux<?> receiveObject();

    default public InetSocketAddress remoteAddress() {
        return this.context().address();
    }
}

