/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.function.Function;
import reactor.netty.channel.ChannelOperations;
import reactor.netty.http.client.HttpClientMetricsRecorder;
import reactor.netty.http.client.HttpClientOperations;
import reactor.util.annotation.Nullable;
import reactor.util.context.ContextView;

abstract class AbstractHttpClientMetricsHandler
extends ChannelDuplexHandler {
    String path;
    String method;
    String status;
    ContextView contextView;
    long dataReceived;
    long dataSent;
    long dataReceivedTime;
    long dataSentTime;
    final Function<String, String> uriTagValue;

    protected AbstractHttpClientMetricsHandler(@Nullable Function<String, String> uriTagValue) {
        this.uriTagValue = uriTagValue;
    }

    protected AbstractHttpClientMetricsHandler(AbstractHttpClientMetricsHandler copy) {
        this.contextView = copy.contextView;
        this.dataReceived = copy.dataReceived;
        this.dataReceivedTime = copy.dataReceivedTime;
        this.dataSent = copy.dataSent;
        this.dataSentTime = copy.dataSentTime;
        this.method = copy.method;
        this.path = copy.path;
        this.status = copy.status;
        this.uriTagValue = copy.uriTagValue;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        if (msg instanceof HttpRequest) {
            this.method = ((HttpRequest)msg).method().name();
            ChannelOperations channelOps = ChannelOperations.get((Channel)ctx.channel());
            if (channelOps instanceof HttpClientOperations) {
                HttpClientOperations ops = (HttpClientOperations)channelOps;
                this.path = this.uriTagValue == null ? ops.path : this.uriTagValue.apply(ops.path);
                this.contextView = ops.currentContextView();
            }
            this.dataSentTime = System.nanoTime();
        }
        if (msg instanceof ByteBufHolder) {
            this.dataSent += (long)((ByteBufHolder)msg).content().readableBytes();
        } else if (msg instanceof ByteBuf) {
            this.dataSent += (long)((ByteBuf)msg).readableBytes();
        }
        if (msg instanceof LastHttpContent) {
            SocketAddress address = ctx.channel().remoteAddress();
            promise.addListener(future -> this.recordWrite(address));
        }
        ctx.write(msg, promise);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof HttpResponse) {
            this.status = ((HttpResponse)msg).status().codeAsText().toString();
            this.dataReceivedTime = System.nanoTime();
        }
        if (msg instanceof ByteBufHolder) {
            this.dataReceived += (long)((ByteBufHolder)msg).content().readableBytes();
        } else if (msg instanceof ByteBuf) {
            this.dataReceived += (long)((ByteBuf)msg).readableBytes();
        }
        if (msg instanceof LastHttpContent) {
            this.recordRead(ctx.channel().remoteAddress());
            this.reset();
        }
        ctx.fireChannelRead(msg);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.recordException(ctx);
        ctx.fireExceptionCaught(cause);
    }

    protected abstract HttpClientMetricsRecorder recorder();

    protected void recordException(ChannelHandlerContext ctx) {
        this.recorder().incrementErrorsCount(ctx.channel().remoteAddress(), this.path != null ? this.path : this.resolveUri(ctx));
    }

    protected void recordRead(SocketAddress address) {
        this.recorder().recordDataReceivedTime(address, this.path, this.method, this.status, Duration.ofNanos(System.nanoTime() - this.dataReceivedTime));
        this.recorder().recordResponseTime(address, this.path, this.method, this.status, Duration.ofNanos(System.nanoTime() - this.dataSentTime));
        this.recorder().recordDataReceived(address, this.path, this.dataReceived);
    }

    protected void recordWrite(SocketAddress address) {
        this.recorder().recordDataSentTime(address, this.path, this.method, Duration.ofNanos(System.nanoTime() - this.dataSentTime));
        this.recorder().recordDataSent(address, this.path, this.dataSent);
    }

    private String resolveUri(ChannelHandlerContext ctx) {
        ChannelOperations channelOps = ChannelOperations.get((Channel)ctx.channel());
        if (channelOps instanceof HttpClientOperations) {
            String path = ((HttpClientOperations)channelOps).uri();
            return this.uriTagValue == null ? path : this.uriTagValue.apply(path);
        }
        return "unknown";
    }

    private void reset() {
        this.path = null;
        this.method = null;
        this.status = null;
        this.contextView = null;
        this.dataReceived = 0L;
        this.dataSent = 0L;
        this.dataReceivedTime = 0L;
        this.dataSentTime = 0L;
    }
}

