/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.tcp;

import io.netty.bootstrap.Bootstrap;
import io.netty.util.AttributeKey;
import java.util.Objects;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.resources.ConnectionProvider;
import reactor.netty.resources.LoopResources;
import reactor.netty.tcp.TcpClient;
import reactor.netty.tcp.TcpClientRunOn;
import reactor.netty.tcp.TcpResources;

final class TcpClientConnect
extends TcpClient {
    static final TcpClientConnect INSTANCE = new TcpClientConnect(ConnectionProvider.newConnection());
    static final AttributeKey<Integer> MAX_CONNECTIONS = AttributeKey.newInstance((String)"maxConnections");
    final ConnectionProvider provider;
    final int maxConnections;

    TcpClientConnect(ConnectionProvider provider) {
        this.provider = Objects.requireNonNull(provider, "connectionProvider");
        this.maxConnections = provider.maxConnections();
    }

    @Override
    public Bootstrap configure() {
        Bootstrap b = super.configure();
        if (this.maxConnections != -1) {
            b.attr(MAX_CONNECTIONS, (Object)this.maxConnections);
        }
        return b;
    }

    @Override
    public Mono<? extends Connection> connect(Bootstrap b) {
        if (b.config().group() == null) {
            TcpClientRunOn.configure(b, LoopResources.DEFAULT_NATIVE, TcpResources.get(), this.maxConnections != -1);
        }
        return this.provider.acquire(b);
    }
}

