/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.function.Function;
import javax.annotation.Nullable;
import reactor.netty.channel.ChannelOperations;
import reactor.netty.http.client.HttpClientMetricsRecorder;
import reactor.netty.http.client.HttpClientOperations;

final class HttpClientMetricsHandler
extends ChannelDuplexHandler {
    String path;
    String method;
    String status;
    long dataReceived;
    long dataSent;
    long dataReceivedTime;
    long dataSentTime;
    final HttpClientMetricsRecorder recorder;
    final Function<String, String> uriTagValue;

    HttpClientMetricsHandler(HttpClientMetricsRecorder recorder, @Nullable Function<String, String> uriTagValue) {
        this.recorder = recorder;
        this.uriTagValue = uriTagValue;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        if (msg instanceof HttpRequest) {
            ChannelOperations<?, ?> channelOps = ChannelOperations.get(ctx.channel());
            if (channelOps instanceof HttpClientOperations) {
                HttpClientOperations ops = (HttpClientOperations)channelOps;
                this.path = this.uriTagValue == null ? ops.path : this.uriTagValue.apply(ops.path);
                this.method = ops.method().name();
            }
            this.dataSentTime = System.nanoTime();
        }
        if (msg instanceof ByteBufHolder) {
            this.dataSent += (long)((ByteBufHolder)msg).content().readableBytes();
        } else if (msg instanceof ByteBuf) {
            this.dataSent += (long)((ByteBuf)msg).readableBytes();
        }
        if (msg instanceof LastHttpContent) {
            promise.addListener(future -> {
                SocketAddress address = ctx.channel().remoteAddress();
                this.recorder.recordDataSentTime(address, this.path, this.method, Duration.ofNanos(System.nanoTime() - this.dataSentTime));
                this.recorder.recordDataSent(address, this.path, this.dataSent);
            });
        }
        ctx.write(msg, promise);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof HttpResponse) {
            HttpResponse response = (HttpResponse)msg;
            this.status = response.status().codeAsText().toString();
            this.dataReceivedTime = System.nanoTime();
        }
        if (msg instanceof ByteBufHolder) {
            this.dataReceived += (long)((ByteBufHolder)msg).content().readableBytes();
        } else if (msg instanceof ByteBuf) {
            this.dataReceived += (long)((ByteBuf)msg).readableBytes();
        }
        if (msg instanceof LastHttpContent) {
            SocketAddress address = ctx.channel().remoteAddress();
            this.recorder.recordDataReceivedTime(address, this.path, this.method, this.status, Duration.ofNanos(System.nanoTime() - this.dataReceivedTime));
            this.recorder.recordResponseTime(address, this.path, this.method, this.status, Duration.ofNanos(System.nanoTime() - this.dataSentTime));
            this.recorder.recordDataReceived(address, this.path, this.dataReceived);
            this.reset();
        }
        ctx.fireChannelRead(msg);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.recorder.incrementErrorsCount(ctx.channel().remoteAddress(), this.path != null ? this.path : this.resolveUri(ctx));
        ctx.fireExceptionCaught(cause);
    }

    private String resolveUri(ChannelHandlerContext ctx) {
        ChannelOperations<?, ?> channelOps = ChannelOperations.get(ctx.channel());
        if (channelOps instanceof HttpClientOperations) {
            String path = ((HttpClientOperations)channelOps).uri();
            return this.uriTagValue == null ? path : this.uriTagValue.apply(path);
        }
        return "unknown";
    }

    private void reset() {
        this.path = null;
        this.method = null;
        this.status = null;
        this.dataReceived = 0L;
        this.dataSent = 0L;
        this.dataReceivedTime = 0L;
        this.dataSentTime = 0L;
    }
}

