/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.internal.shaded.reactor.pool;

import java.time.Duration;
import java.util.Deque;
import java.util.Iterator;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.BiPredicate;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Disposable;
import reactor.core.Disposables;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;
import reactor.netty.internal.shaded.reactor.pool.AbstractPool;
import reactor.netty.internal.shaded.reactor.pool.PoolAcquirePendingLimitException;
import reactor.netty.internal.shaded.reactor.pool.PoolConfig;
import reactor.netty.internal.shaded.reactor.pool.PoolShutdownException;
import reactor.netty.internal.shaded.reactor.pool.PooledRef;
import reactor.util.Loggers;
import reactor.util.annotation.Nullable;
import reactor.util.context.Context;

public class SimpleDequePool<POOLABLE>
extends AbstractPool<POOLABLE> {
    private static final ConcurrentLinkedDeque TERMINATED = new ConcurrentLinkedDeque();
    final boolean idleResourceLeastRecentlyUsed;
    final boolean pendingBorrowerFirstInFirstServed;
    volatile Deque<QueuePooledRef<POOLABLE>> idleResources;
    protected static final AtomicReferenceFieldUpdater<SimpleDequePool, Deque> IDLE_RESOURCES = AtomicReferenceFieldUpdater.newUpdater(SimpleDequePool.class, Deque.class, "idleResources");
    volatile int acquired;
    private static final AtomicIntegerFieldUpdater<SimpleDequePool> ACQUIRED = AtomicIntegerFieldUpdater.newUpdater(SimpleDequePool.class, "acquired");
    volatile int wip;
    private static final AtomicIntegerFieldUpdater<SimpleDequePool> WIP = AtomicIntegerFieldUpdater.newUpdater(SimpleDequePool.class, "wip");
    volatile ConcurrentLinkedDeque<AbstractPool.Borrower<POOLABLE>> pending;
    private static final AtomicReferenceFieldUpdater<SimpleDequePool, ConcurrentLinkedDeque> PENDING = AtomicReferenceFieldUpdater.newUpdater(SimpleDequePool.class, ConcurrentLinkedDeque.class, "pending");
    Disposable evictionTask;

    SimpleDequePool(PoolConfig<POOLABLE> poolConfig, boolean pendingBorrowerFirstInFirstServed) {
        super(poolConfig, Loggers.getLogger(SimpleDequePool.class));
        this.idleResourceLeastRecentlyUsed = poolConfig.reuseIdleResourcesInLruOrder();
        this.pendingBorrowerFirstInFirstServed = pendingBorrowerFirstInFirstServed;
        this.pending = new ConcurrentLinkedDeque();
        this.idleResources = new ConcurrentLinkedDeque<QueuePooledRef<POOLABLE>>();
        this.scheduleEviction();
    }

    @Override
    public Mono<PooledRef<POOLABLE>> acquire() {
        return new QueueBorrowerMono(this, Duration.ZERO);
    }

    @Override
    public Mono<PooledRef<POOLABLE>> acquire(Duration timeout) {
        return new QueueBorrowerMono(this, timeout);
    }

    @Override
    public int acquiredSize() {
        return this.acquired;
    }

    void scheduleEviction() {
        if (!this.poolConfig.evictInBackgroundInterval().isZero()) {
            long nanosEvictionInterval = this.poolConfig.evictInBackgroundInterval().toNanos();
            this.evictionTask = this.poolConfig.evictInBackgroundScheduler().schedule(this::evictInBackground, nanosEvictionInterval, TimeUnit.NANOSECONDS);
        } else {
            this.evictionTask = Disposables.disposed();
        }
    }

    void evictInBackground() {
        Queue e = IDLE_RESOURCES.get(this);
        if (e == null) {
            return;
        }
        if (WIP.getAndIncrement(this) == 0) {
            if (PENDING_COUNT.get(this) == 0) {
                BiPredicate evictionPredicate = this.poolConfig.evictionPredicate();
                Iterator iterator = e.iterator();
                while (iterator.hasNext()) {
                    QueuePooledRef pooledRef = (QueuePooledRef)iterator.next();
                    if (!evictionPredicate.test(pooledRef.poolable, pooledRef) || !pooledRef.markInvalidate()) continue;
                    iterator.remove();
                    this.destroyPoolable(pooledRef).subscribe();
                }
            }
            if (WIP.decrementAndGet(this) > 0) {
                this.drainLoop();
            }
        }
        this.scheduleEviction();
    }

    @Override
    public Mono<Void> disposeLater() {
        return Mono.defer(() -> {
            ConcurrentLinkedDeque q = PENDING.getAndSet(this, TERMINATED);
            if (q != TERMINATED) {
                AbstractPool.Borrower p;
                this.evictionTask.dispose();
                while ((p = (AbstractPool.Borrower)q.pollFirst()) != null) {
                    p.fail(new PoolShutdownException());
                }
                Queue e = IDLE_RESOURCES.getAndSet(this, null);
                if (e != null) {
                    Mono destroyMonos = Mono.empty();
                    while (!e.isEmpty()) {
                        QueuePooledRef ref = (QueuePooledRef)e.poll();
                        if (!ref.markInvalidate()) continue;
                        destroyMonos = destroyMonos.and(this.destroyPoolable(ref));
                    }
                    return destroyMonos;
                }
            }
            return Mono.empty();
        });
    }

    @Override
    public int idleSize() {
        Queue e = IDLE_RESOURCES.get(this);
        return e == null ? 0 : e.size();
    }

    @Override
    public Mono<Integer> warmup() {
        if (this.poolConfig.allocationStrategy().permitMinimum() > 0) {
            return Mono.deferWithContext(ctx -> {
                int initSize = this.poolConfig.allocationStrategy().getPermits(0);
                Mono[] allWarmups = new Mono[initSize];
                for (int i = 0; i < initSize; ++i) {
                    long start = this.clock.millis();
                    allWarmups[i] = this.poolConfig.allocator().subscriberContext(ctx).doOnNext(p -> {
                        this.metricsRecorder.recordAllocationSuccessAndLatency(this.clock.millis() - start);
                        this.idleResources.offerLast(this.createSlot(p));
                    }).doOnError(e -> {
                        this.metricsRecorder.recordAllocationFailureAndLatency(this.clock.millis() - start);
                        this.poolConfig.allocationStrategy().returnPermits(1);
                    });
                }
                return Flux.concat((Publisher[])allWarmups).reduce((Object)0, (count, p) -> count + 1);
            });
        }
        return Mono.just((Object)0);
    }

    @Override
    void cancelAcquire(AbstractPool.Borrower<POOLABLE> borrower) {
        ConcurrentLinkedDeque<AbstractPool.Borrower<POOLABLE>> q;
        if (!this.isDisposed() && (q = this.pending).remove(borrower)) {
            PENDING_COUNT.decrementAndGet(this);
        }
    }

    QueuePooledRef<POOLABLE> createSlot(POOLABLE element) {
        return new QueuePooledRef<POOLABLE>(this, element);
    }

    @Override
    void doAcquire(AbstractPool.Borrower<POOLABLE> borrower) {
        if (this.isDisposed()) {
            borrower.fail(new PoolShutdownException());
            return;
        }
        this.pendingOffer(borrower);
        this.drain();
    }

    void drain() {
        if (WIP.getAndIncrement(this) == 0) {
            this.drainLoop();
        }
    }

    private void drainLoop() {
        while (true) {
            Deque irq;
            if ((irq = IDLE_RESOURCES.get(this)) != null) {
                int availableCount = irq.size();
                int pendingCount = PENDING_COUNT.get(this);
                int estimatedPermitCount = this.poolConfig.allocationStrategy().estimatePermitCount();
                if (availableCount == 0) {
                    if (pendingCount > 0 && estimatedPermitCount > 0) {
                        AbstractPool.Borrower<POOLABLE> borrower = this.pendingPoll();
                        if (borrower == null) continue;
                        ACQUIRED.incrementAndGet(this);
                        int permits = this.poolConfig.allocationStrategy().getPermits(1);
                        if (borrower.get() || permits == 0) {
                            ACQUIRED.decrementAndGet(this);
                            continue;
                        }
                        borrower.stopPendingCountdown();
                        long start = this.clock.millis();
                        Scheduler s = this.poolConfig.acquisitionScheduler();
                        Mono allocator = s != Schedulers.immediate() ? this.poolConfig.allocator().publishOn(s) : this.poolConfig.allocator();
                        Mono primary = allocator.doOnEach(sig -> {
                            if (sig.isOnNext()) {
                                Object newInstance = sig.get();
                                this.metricsRecorder.recordAllocationSuccessAndLatency(this.clock.millis() - start);
                                borrower.deliver(this.createSlot(newInstance));
                            } else if (sig.isOnError()) {
                                this.metricsRecorder.recordAllocationFailureAndLatency(this.clock.millis() - start);
                                ACQUIRED.decrementAndGet(this);
                                this.poolConfig.allocationStrategy().returnPermits(1);
                                borrower.fail(sig.getThrowable());
                                this.drain();
                            }
                        }).subscriberContext(borrower.currentContext());
                        int toWarmup = permits - 1;
                        if (toWarmup < 1) {
                            primary.subscribe(alreadyPropagated -> {}, alreadyPropagatedOrLogged -> {});
                        } else {
                            this.logger.debug("should warm up {} extra resources", new Object[]{toWarmup});
                            long startWarmupIteration = this.clock.millis();
                            Mono warmup = Flux.range((int)1, (int)toWarmup).flatMap(i -> allocator.doOnNext(poolable -> {
                                this.logger.debug("warmed up extra resource {}/{}", new Object[]{i, toWarmup});
                                this.metricsRecorder.recordAllocationSuccessAndLatency(this.clock.millis() - startWarmupIteration);
                                irq.offer(new QueuePooledRef<Object>(this, poolable));
                                this.drain();
                            }).onErrorResume(warmupError -> {
                                this.logger.debug("failed to warm up extra resource {}/{}: {}", new Object[]{i, toWarmup, warmupError.toString()});
                                this.metricsRecorder.recordAllocationFailureAndLatency(this.clock.millis() - startWarmupIteration);
                                this.poolConfig.allocationStrategy().returnPermits(1);
                                this.drain();
                                return Mono.empty();
                            })).then();
                            primary.onErrorResume(ignore -> Mono.empty()).thenMany((Publisher)warmup).subscribe(alreadyPropagated -> {}, alreadyPropagatedOrLogged -> {});
                        }
                    }
                } else if (pendingCount > 0) {
                    QueuePooledRef slot;
                    if (this.isDisposed() || (slot = this.idleResourceLeastRecentlyUsed ? (QueuePooledRef)irq.pollFirst() : (QueuePooledRef)irq.pollLast()) == null) continue;
                    if (this.poolConfig.evictionPredicate().test(slot.poolable, slot) && slot.markInvalidate()) {
                        this.destroyPoolable(slot).subscribe(null, error -> this.drain(), this::drain);
                        continue;
                    }
                    AbstractPool.Borrower inner = this.pendingPoll();
                    if (inner == null) {
                        if (this.isDisposed()) continue;
                        if (this.idleResourceLeastRecentlyUsed) {
                            irq.offerFirst(slot);
                            continue;
                        }
                        irq.offerLast(slot);
                        continue;
                    }
                    inner.stopPendingCountdown();
                    ACQUIRED.incrementAndGet(this);
                    this.poolConfig.acquisitionScheduler().schedule(() -> inner.deliver(slot));
                }
            }
            if (WIP.decrementAndGet(this) == 0) break;
        }
    }

    @Override
    boolean elementOffer(POOLABLE element) {
        Deque irq = IDLE_RESOURCES.get(this);
        if (irq == null) {
            return false;
        }
        return irq.offerLast(this.createSlot(element));
    }

    final void maybeRecycleAndDrain(QueuePooledRef<POOLABLE> poolSlot) {
        if (!this.isDisposed() && !this.poolConfig.evictionPredicate().test(poolSlot.poolable, poolSlot)) {
            this.metricsRecorder.recordRecycled();
            Deque irq = IDLE_RESOURCES.get(this);
            if (irq != null) {
                QueuePooledRef<POOLABLE> slot = this.recycleSlot(poolSlot);
                irq.offerLast(slot);
                this.drain();
                if (this.isDisposed() && slot.markInvalidate()) {
                    this.destroyPoolable(slot).subscribe();
                }
                return;
            }
        }
        if (poolSlot.markInvalidate()) {
            this.destroyPoolable(poolSlot).subscribe(null, e -> this.drain(), this::drain);
        }
    }

    boolean pendingOffer(AbstractPool.Borrower<POOLABLE> pending) {
        int currentPending;
        int maxPending = this.poolConfig.maxPending();
        do {
            Deque<QueuePooledRef<POOLABLE>> ir;
            currentPending = PENDING_COUNT.get(this);
            if (maxPending < 0 || currentPending != maxPending || !(ir = this.idleResources).isEmpty() || this.poolConfig.allocationStrategy().estimatePermitCount() != 0) continue;
            if (maxPending == 0) {
                pending.fail(new PoolAcquirePendingLimitException(0, "No pending allowed and pool has reached allocation limit"));
            } else {
                pending.fail(new PoolAcquirePendingLimitException(maxPending));
            }
            return false;
        } while (!PENDING_COUNT.compareAndSet(this, currentPending, currentPending + 1));
        this.pending.offerLast(pending);
        return true;
    }

    @Nullable
    AbstractPool.Borrower<POOLABLE> pendingPoll() {
        AbstractPool.Borrower b;
        ConcurrentLinkedDeque<AbstractPool.Borrower<POOLABLE>> pq = this.pending;
        AbstractPool.Borrower borrower = b = this.pendingBorrowerFirstInFirstServed ? (AbstractPool.Borrower)pq.pollFirst() : (AbstractPool.Borrower)pq.pollLast();
        if (b != null) {
            PENDING_COUNT.decrementAndGet(this);
        }
        return b;
    }

    QueuePooledRef<POOLABLE> recycleSlot(QueuePooledRef<POOLABLE> slot) {
        return new QueuePooledRef<POOLABLE>(slot);
    }

    public boolean isDisposed() {
        return PENDING.get(this) == TERMINATED;
    }

    private static final class QueuePoolRecyclerMono<T>
    extends Mono<Void>
    implements Scannable {
        final Publisher<Void> source;
        final AtomicReference<QueuePooledRef<T>> slotRef;

        QueuePoolRecyclerMono(Publisher<Void> source, QueuePooledRef<T> poolSlot) {
            this.source = source;
            this.slotRef = new AtomicReference<QueuePooledRef<T>>(poolSlot);
        }

        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PREFETCH) {
                return Integer.MAX_VALUE;
            }
            if (key == Scannable.Attr.PARENT) {
                return this.source;
            }
            return null;
        }

        public void subscribe(CoreSubscriber<? super Void> actual) {
            QueuePooledRef slot = this.slotRef.getAndSet(null);
            if (slot == null || !slot.markReleased()) {
                Operators.complete(actual);
            } else {
                QueuePoolRecyclerInner qpr = new QueuePoolRecyclerInner(actual, slot);
                this.source.subscribe(qpr);
            }
        }
    }

    private static final class QueuePoolRecyclerInner<T>
    implements CoreSubscriber<Void>,
    Scannable,
    Subscription {
        final CoreSubscriber<? super Void> actual;
        final SimpleDequePool<T> pool;
        QueuePooledRef<T> pooledRef;
        Subscription upstream;
        long start;
        volatile int once;
        static final AtomicIntegerFieldUpdater<QueuePoolRecyclerInner> ONCE = AtomicIntegerFieldUpdater.newUpdater(QueuePoolRecyclerInner.class, "once");

        QueuePoolRecyclerInner(CoreSubscriber<? super Void> actual, QueuePooledRef<T> pooledRef) {
            this.actual = actual;
            this.pooledRef = Objects.requireNonNull(pooledRef, "pooledRef");
            this.pool = pooledRef.pool;
        }

        public void cancel() {
        }

        public void onComplete() {
            QueuePooledRef<T> slot = this.pooledRef;
            this.pooledRef = null;
            if (slot == null) {
                return;
            }
            if (ONCE.compareAndSet(this, 0, 1)) {
                ACQUIRED.decrementAndGet(this.pool);
            }
            this.pool.metricsRecorder.recordResetLatency(this.pool.clock.millis() - this.start);
            this.pool.maybeRecycleAndDrain(slot);
            this.actual.onComplete();
        }

        public void onError(Throwable throwable) {
            QueuePooledRef<T> slot = this.pooledRef;
            this.pooledRef = null;
            if (slot == null) {
                Operators.onErrorDropped((Throwable)throwable, (Context)this.actual.currentContext());
                return;
            }
            if (ONCE.compareAndSet(this, 0, 1)) {
                ACQUIRED.decrementAndGet(this.pool);
            }
            this.pool.metricsRecorder.recordResetLatency(this.pool.clock.millis() - this.start);
            if (slot.markInvalidate()) {
                this.pool.destroyPoolable(slot).subscribe(null, null, this.pool::drain);
            }
            this.actual.onError(throwable);
        }

        public void onNext(Void o) {
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate((Subscription)this.upstream, (Subscription)s)) {
                this.upstream = s;
                this.actual.onSubscribe((Subscription)this);
                this.start = this.pool.clock.millis();
            }
        }

        public void request(long l) {
            if (Operators.validate((long)l)) {
                this.upstream.request(l);
                if (ONCE.compareAndSet(this, 0, 1)) {
                    ACQUIRED.decrementAndGet(this.pool);
                }
            }
        }

        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.ACTUAL) {
                return this.actual;
            }
            if (key == Scannable.Attr.PARENT) {
                return this.upstream;
            }
            if (key == Scannable.Attr.CANCELLED) {
                return false;
            }
            if (key == Scannable.Attr.TERMINATED) {
                return this.pooledRef == null;
            }
            if (key == Scannable.Attr.BUFFERED) {
                return this.pooledRef == null ? 0 : 1;
            }
            return null;
        }
    }

    static final class QueueBorrowerMono<T>
    extends Mono<PooledRef<T>> {
        final SimpleDequePool<T> parent;
        final Duration acquireTimeout;

        QueueBorrowerMono(SimpleDequePool<T> pool, Duration acquireTimeout) {
            this.parent = pool;
            this.acquireTimeout = acquireTimeout;
        }

        public void subscribe(CoreSubscriber<? super PooledRef<T>> actual) {
            Objects.requireNonNull(actual, "subscribing with null");
            AbstractPool.Borrower<T> borrower = new AbstractPool.Borrower<T>(actual, this.parent, this.acquireTimeout);
            actual.onSubscribe(borrower);
        }
    }

    static final class QueuePooledRef<T>
    extends AbstractPool.AbstractPooledRef<T> {
        final SimpleDequePool<T> pool;

        QueuePooledRef(SimpleDequePool<T> pool, T poolable) {
            super(poolable, pool.metricsRecorder, pool.clock);
            this.pool = pool;
        }

        QueuePooledRef(QueuePooledRef<T> oldRef) {
            super(oldRef);
            this.pool = oldRef.pool;
        }

        @Override
        public Mono<Void> invalidate() {
            return Mono.defer(() -> {
                if (this.markInvalidate()) {
                    ACQUIRED.decrementAndGet(this.pool);
                    return this.pool.destroyPoolable(this).then(Mono.fromRunnable(this.pool::drain));
                }
                return Mono.empty();
            });
        }

        @Override
        public Mono<Void> release() {
            return Mono.defer(() -> {
                Publisher<Void> cleaner;
                if (STATE.get(this) == 2) {
                    return Mono.empty();
                }
                if (this.pool.isDisposed()) {
                    ACQUIRED.decrementAndGet(this.pool);
                    if (this.markInvalidate()) {
                        return this.pool.destroyPoolable(this);
                    }
                    return Mono.empty();
                }
                try {
                    cleaner = this.pool.poolConfig.releaseHandler().apply(this.poolable);
                }
                catch (Throwable e) {
                    ACQUIRED.decrementAndGet(this.pool);
                    this.markReleased();
                    return Mono.error((Throwable)new IllegalStateException("Couldn't apply cleaner function", e));
                }
                return new QueuePoolRecyclerMono(cleaner, this);
            });
        }
    }
}

