/*
 * Decompiled with CFR 0.152.
 */
package reactor.rx.action;

import java.io.Serializable;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.fn.Consumer;
import reactor.fn.Supplier;

public final class Signal<T>
implements Supplier<T>,
Consumer<Subscriber<? super T>>,
Serializable {
    private static final Signal<Void> ON_COMPLETE = new Signal<Object>(Type.COMPLETE, null, null, null);
    private final Type type;
    private final Throwable throwable;
    private final T value;
    private final transient Subscription subscription;

    public static <T> Signal<T> next(T t) {
        return new Signal<T>(Type.NEXT, t, null, null);
    }

    public static <T> Signal<T> error(Throwable e) {
        return new Signal<Object>(Type.ERROR, null, e, null);
    }

    public static <T> Signal<T> complete() {
        return ON_COMPLETE;
    }

    public static <T> Signal<T> subscribe(Subscription subscription) {
        return new Signal<Object>(Type.SUBSCRIBE, null, null, subscription);
    }

    private Signal(Type type, T value, Throwable e, Subscription subscription) {
        this.value = value;
        this.subscription = subscription;
        this.throwable = e;
        this.type = type;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public Subscription getSubscription() {
        return this.subscription;
    }

    public T get() {
        return this.value;
    }

    public boolean hasValue() {
        return this.isOnNext() && this.value != null;
    }

    public boolean hasError() {
        return this.isOnError() && this.throwable != null;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isOnError() {
        return this.getType() == Type.ERROR;
    }

    public boolean isOnComplete() {
        return this.getType() == Type.COMPLETE;
    }

    public boolean isOnSubscribe() {
        return this.getType() == Type.SUBSCRIBE;
    }

    public boolean isOnNext() {
        return this.getType() == Type.NEXT;
    }

    public void accept(Subscriber<? super T> observer) {
        if (this.isOnNext()) {
            observer.onNext(this.get());
        } else if (this.isOnComplete()) {
            observer.onComplete();
        } else if (this.isOnError()) {
            observer.onError(this.getThrowable());
        } else if (this.isOnSubscribe()) {
            observer.onSubscribe(this.subscription);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Signal signal = (Signal)o;
        if (this.type != signal.type) {
            return false;
        }
        if (this.isOnComplete()) {
            return true;
        }
        if (this.isOnSubscribe() && this.subscription != null ? !this.subscription.equals(signal.subscription) : signal.subscription != null) {
            return false;
        }
        if (this.isOnError() && this.throwable != null ? !this.throwable.equals(signal.throwable) : signal.throwable != null) {
            return false;
        }
        return this.isOnNext() && this.value != null ? !this.value.equals(signal.value) : signal.value != null;
    }

    public int hashCode() {
        int result;
        int n = result = this.type != null ? this.type.hashCode() : 0;
        if (this.isOnError()) {
            result = 31 * result + (this.throwable != null ? this.throwable.hashCode() : 0);
        }
        if (this.isOnNext()) {
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        }
        if (this.isOnComplete()) {
            result = 31 * result + (this.subscription != null ? this.subscription.hashCode() : 0);
        }
        return result;
    }

    public String toString() {
        return "Signal{type=" + (Object)((Object)this.type) + (this.isOnError() ? ", throwable=" + this.throwable : (this.isOnNext() ? ", value=" + this.value : (this.isOnSubscribe() ? ", subscription=" + this.subscription : ""))) + '}';
    }

    public static enum Type {
        SUBSCRIBE,
        NEXT,
        COMPLETE,
        ERROR;

    }
}

