/*
 * Decompiled with CFR 0.152.
 */
package reactor.rx.action.transformation;

import reactor.fn.BiFunction;
import reactor.rx.action.Action;

public class ScanAction<T, A>
extends Action<T, A> {
    private final BiFunction<A, ? super T, A> fn;
    private final A initialValue;
    private A acc;
    private boolean initialized = false;
    private static final Object NOVALUE_SENTINEL = new Object();

    public ScanAction(A initial, BiFunction<A, ? super T, A> fn) {
        this.initialValue = initial == null ? NOVALUE_SENTINEL : initial;
        this.acc = this.initialValue;
        this.fn = fn;
    }

    @Override
    protected void doNext(T ev) {
        this.checkInit();
        this.acc = this.acc == NOVALUE_SENTINEL ? ev : this.fn.apply(this.acc, ev);
        this.broadcastNext(this.acc);
    }

    @Override
    protected void doComplete() {
        this.checkInit();
        super.doComplete();
    }

    private void checkInit() {
        if (!this.initialized) {
            this.initialized = true;
            if (this.initialValue != NOVALUE_SENTINEL) {
                this.broadcastNext(this.initialValue);
            }
        }
    }
}

