/*
 * Decompiled with CFR 0.152.
 */
package reactor.rx.subscription;

import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.rx.subscription.support.WrappedSubscription;

public final class BatchSubscription<T>
extends WrappedSubscription<T> {
    private final int batchSize;

    public BatchSubscription(Subscription subscription, Subscriber<T> subscriber, int batchSize) {
        super(subscription, subscriber);
        this.batchSize = batchSize;
    }

    @Override
    public void request(long n) {
        if (this.pushSubscription != null) {
            if (n == Long.MAX_VALUE) {
                this.pushSubscription.request(Long.MAX_VALUE);
            } else if (this.pushSubscription.pendingRequestSignals() != Long.MAX_VALUE) {
                long toRequest = n * (long)this.batchSize;
                toRequest = toRequest > 0L ? toRequest : Long.MAX_VALUE;
                this.pushSubscription.request(toRequest);
            }
        } else {
            super.request(n);
        }
    }
}

