/*
 * Decompiled with CFR 0.152.
 */
package reactor.test;

import java.util.Optional;
import java.util.function.Function;
import reactor.test.DefaultStepVerifierBuilder;
import reactor.util.annotation.Nullable;

final class ErrorFormatter {
    private static final String EMPTY = "";
    final String scenarioPrefix;

    ErrorFormatter(@Nullable String scenarioName) {
        this.scenarioPrefix = scenarioName == null || scenarioName.isEmpty() ? EMPTY : "[" + scenarioName + "] ";
    }

    AssertionError fail(@Nullable DefaultStepVerifierBuilder.Event<?> event, String msg, Object ... args) {
        String prefix = event != null && event.getDescription().length() > 0 ? String.format("expectation \"%s\" failed (", event.getDescription()) : "expectation failed (";
        return this.failPrefix(prefix, msg, args);
    }

    Optional<AssertionError> failOptional(@Nullable DefaultStepVerifierBuilder.Event<?> event, String msg, Object ... args) {
        return Optional.of(this.fail(event, msg, args));
    }

    AssertionError failPrefix(String prefix, String msg, Object ... args) {
        return this.assertionError(prefix + String.format(msg, args) + ")");
    }

    AssertionError assertionError(String msg) {
        return new AssertionError((Object)(this.scenarioPrefix + msg));
    }

    AssertionError assertionError(String msg, @Nullable Throwable cause) {
        return new AssertionError(this.scenarioPrefix + msg, cause);
    }

    <T extends Throwable> T error(Function<String, T> errorProducer, String message) {
        return (T)((Throwable)errorProducer.apply(this.scenarioPrefix + message));
    }
}

