/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.concurrent.atomic.AtomicReference;
import rx.Observable;
import rx.Subscriber;
import rx.observers.SerializedSubscriber;

public final class OperatorSampleWithObservable<T, U>
implements Observable.Operator<T, T> {
    final Observable<U> sampler;
    static final Object EMPTY_TOKEN = new Object();

    public OperatorSampleWithObservable(Observable<U> sampler) {
        this.sampler = sampler;
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super T> child) {
        final SerializedSubscriber<? super T> s = new SerializedSubscriber<T>(child);
        final AtomicReference<Object> value = new AtomicReference<Object>(EMPTY_TOKEN);
        Subscriber samplerSub = new Subscriber<U>(child){

            @Override
            public void onNext(U t) {
                Object localValue = value.getAndSet(EMPTY_TOKEN);
                if (localValue != EMPTY_TOKEN) {
                    Object v = localValue;
                    s.onNext(v);
                }
            }

            @Override
            public void onError(Throwable e) {
                s.onError(e);
                this.unsubscribe();
            }

            @Override
            public void onCompleted() {
                s.onCompleted();
                this.unsubscribe();
            }
        };
        Subscriber result = new Subscriber<T>(child){

            @Override
            public void onNext(T t) {
                value.set(t);
            }

            @Override
            public void onError(Throwable e) {
                s.onError(e);
                this.unsubscribe();
            }

            @Override
            public void onCompleted() {
                s.onCompleted();
                this.unsubscribe();
            }
        };
        this.sampler.unsafeSubscribe(samplerSub);
        return result;
    }
}

