/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.schedulers;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicReference;
import rx.internal.schedulers.NewThreadWorker;
import rx.internal.schedulers.SchedulerLifecycle;
import rx.internal.util.RxThreadFactory;

public final class GenericScheduledExecutorService
implements SchedulerLifecycle {
    private static final String THREAD_NAME_PREFIX = "RxScheduledExecutorPool-";
    private static final RxThreadFactory THREAD_FACTORY = new RxThreadFactory("RxScheduledExecutorPool-");
    private static final ScheduledExecutorService NONE = Executors.newScheduledThreadPool(0);
    public static final GenericScheduledExecutorService INSTANCE;
    private final AtomicReference<ScheduledExecutorService> executor = new AtomicReference<ScheduledExecutorService>(NONE);

    private GenericScheduledExecutorService() {
        this.start();
    }

    @Override
    public void start() {
        ScheduledExecutorService exec;
        int count = Runtime.getRuntime().availableProcessors();
        if (count > 4) {
            count /= 2;
        }
        if (count > 8) {
            count = 8;
        }
        if (this.executor.compareAndSet(NONE, exec = Executors.newScheduledThreadPool(count, THREAD_FACTORY))) {
            if (!NewThreadWorker.tryEnableCancelPolicy(exec) && exec instanceof ScheduledThreadPoolExecutor) {
                NewThreadWorker.registerExecutor((ScheduledThreadPoolExecutor)exec);
            }
        } else {
            exec.shutdownNow();
        }
    }

    @Override
    public void shutdown() {
        ScheduledExecutorService exec;
        do {
            if ((exec = this.executor.get()) != NONE) continue;
            return;
        } while (!this.executor.compareAndSet(exec, NONE));
        NewThreadWorker.deregisterExecutor(exec);
        exec.shutdownNow();
    }

    public static ScheduledExecutorService getInstance() {
        return GenericScheduledExecutorService.INSTANCE.executor.get();
    }

    static {
        NONE.shutdownNow();
        INSTANCE = new GenericScheduledExecutorService();
    }
}

