/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.frame;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import reactor.util.annotation.Nullable;

class FrameBodyCodec {
    public static final int FRAME_LENGTH_MASK = 0xFFFFFF;

    private FrameBodyCodec() {
    }

    private static void encodeLength(ByteBuf byteBuf, int length) {
        if ((length & 0xFF000000) != 0) {
            throw new IllegalArgumentException("Length is larger than 24 bits");
        }
        byteBuf.writeByte(length >> 16);
        byteBuf.writeByte(length >> 8);
        byteBuf.writeByte(length);
    }

    private static int decodeLength(ByteBuf byteBuf) {
        byte b = byteBuf.readByte();
        int length = (b & 0xFF) << 16;
        byte b1 = byteBuf.readByte();
        length |= (b1 & 0xFF) << 8;
        byte b2 = byteBuf.readByte();
        return length |= b2 & 0xFF;
    }

    static ByteBuf encode(ByteBufAllocator allocator, ByteBuf header, @Nullable ByteBuf metadata, boolean hasMetadata, @Nullable ByteBuf data) {
        boolean addMetadata;
        boolean addData;
        if (data != null) {
            if (data.isReadable()) {
                addData = true;
            } else {
                data.release();
                addData = false;
            }
        } else {
            addData = false;
        }
        if (hasMetadata) {
            if (metadata.isReadable()) {
                addMetadata = true;
            } else {
                metadata.release();
                addMetadata = false;
            }
        } else {
            addMetadata = false;
        }
        if (hasMetadata) {
            int length = metadata.readableBytes();
            FrameBodyCodec.encodeLength(header, length);
        }
        if (addMetadata && addData) {
            return allocator.compositeBuffer(3).addComponents(true, new ByteBuf[]{header, metadata, data});
        }
        if (addMetadata) {
            return allocator.compositeBuffer(2).addComponents(true, new ByteBuf[]{header, metadata});
        }
        if (addData) {
            return allocator.compositeBuffer(2).addComponents(true, new ByteBuf[]{header, data});
        }
        return header;
    }

    static ByteBuf metadataWithoutMarking(ByteBuf byteBuf) {
        int length = FrameBodyCodec.decodeLength(byteBuf);
        return byteBuf.readSlice(length);
    }

    static ByteBuf dataWithoutMarking(ByteBuf byteBuf, boolean hasMetadata) {
        if (hasMetadata) {
            int length = FrameBodyCodec.decodeLength(byteBuf);
            byteBuf.skipBytes(length);
        }
        if (byteBuf.readableBytes() > 0) {
            return byteBuf.readSlice(byteBuf.readableBytes());
        }
        return Unpooled.EMPTY_BUFFER;
    }
}

