/*
 * Decompiled with CFR 0.152.
 */
package io.seata.core.compressor;

import io.seata.common.loader.EnhancedServiceLoader;
import io.seata.common.loader.LoadLevel;
import io.seata.core.compressor.Compressor;
import io.seata.core.compressor.CompressorType;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CompressorFactory {
    protected static final Map<CompressorType, Compressor> COMPRESSOR_MAP = new ConcurrentHashMap<CompressorType, Compressor>();

    public static Compressor getCompressor(byte code) {
        CompressorType type = CompressorType.getByCode(code);
        if (COMPRESSOR_MAP.get((Object)type) != null) {
            return COMPRESSOR_MAP.get((Object)type);
        }
        Compressor impl = EnhancedServiceLoader.load(Compressor.class, type.name());
        COMPRESSOR_MAP.putIfAbsent(type, impl);
        return impl;
    }

    static {
        COMPRESSOR_MAP.put(CompressorType.NONE, new NoneCompressor());
    }

    @LoadLevel(name="NONE")
    public static class NoneCompressor
    implements Compressor {
        @Override
        public byte[] compress(byte[] bytes) {
            return bytes;
        }

        @Override
        public byte[] decompress(byte[] bytes) {
            return bytes;
        }
    }
}

