/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.util;

import io.seata.common.loader.EnhancedServiceLoader;
import io.seata.config.ConfigurationFactory;
import io.seata.sqlparser.util.DbTypeParser;

public final class JdbcUtils {
    private static volatile DbTypeParser dbTypeParser;

    private JdbcUtils() {
    }

    public static String getDbType(String jdbcUrl) {
        return JdbcUtils.getDbTypeParser().parseFromJdbcUrl(jdbcUrl).toLowerCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static DbTypeParser getDbTypeParser() {
        if (dbTypeParser != null) return dbTypeParser;
        Class<JdbcUtils> clazz = JdbcUtils.class;
        synchronized (JdbcUtils.class) {
            if (dbTypeParser != null) return dbTypeParser;
            String sqlparserType = ConfigurationFactory.getInstance().getConfig("client.rm.sqlParserType", "druid");
            dbTypeParser = EnhancedServiceLoader.load(DbTypeParser.class, sqlparserType);
            // ** MonitorExit[var0] (shouldn't be in output)
            return dbTypeParser;
        }
    }
}

