/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.undo.parser;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ArrayNode;
import io.seata.common.Constants;
import io.seata.common.executor.Initialize;
import io.seata.common.loader.LoadLevel;
import io.seata.rm.datasource.undo.BranchUndoLog;
import io.seata.rm.datasource.undo.UndoLogParser;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialClob;
import javax.sql.rowset.serial.SerialException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LoadLevel(name="jackson")
public class JacksonUndoLogParser
implements UndoLogParser,
Initialize {
    public static final String NAME = "jackson";
    private static final Logger LOGGER = LoggerFactory.getLogger(JacksonUndoLogParser.class);
    private final ObjectMapper mapper = new ObjectMapper();
    private final SimpleModule module = new SimpleModule();
    private final JsonSerializer timestampSerializer = new TimestampSerializer();
    private final JsonDeserializer timestampDeserializer = new TimestampDeserializer();
    private final JsonSerializer blobSerializer = new BlobSerializer();
    private final JsonDeserializer blobDeserializer = new BlobDeserializer();
    private final JsonSerializer clobSerializer = new ClobSerializer();
    private final JsonDeserializer clobDeserializer = new ClobDeserializer();

    @Override
    public void init() {
        this.module.addSerializer(Timestamp.class, this.timestampSerializer);
        this.module.addDeserializer(Timestamp.class, this.timestampDeserializer);
        this.module.addSerializer(SerialBlob.class, this.blobSerializer);
        this.module.addDeserializer(SerialBlob.class, this.blobDeserializer);
        this.module.addSerializer(SerialClob.class, this.clobSerializer);
        this.module.addDeserializer(SerialClob.class, this.clobDeserializer);
        this.mapper.registerModule((Module)this.module);
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.mapper.enableDefaultTyping(ObjectMapper.DefaultTyping.NON_FINAL, JsonTypeInfo.As.PROPERTY);
        this.mapper.enable(new MapperFeature[]{MapperFeature.PROPAGATE_TRANSIENT_MARKER});
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public byte[] getDefaultContent() {
        return "{}".getBytes(Constants.DEFAULT_CHARSET);
    }

    @Override
    public byte[] encode(BranchUndoLog branchUndoLog) {
        try {
            return this.mapper.writeValueAsBytes((Object)branchUndoLog);
        }
        catch (JsonProcessingException e) {
            LOGGER.error("json encode exception, {}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public BranchUndoLog decode(byte[] bytes) {
        try {
            BranchUndoLog branchUndoLog = Arrays.equals(bytes, this.getDefaultContent()) ? new BranchUndoLog() : (BranchUndoLog)this.mapper.readValue(bytes, BranchUndoLog.class);
            return branchUndoLog;
        }
        catch (IOException e) {
            LOGGER.error("json decode exception, {}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException(e);
        }
    }

    private static class ClobDeserializer
    extends JsonDeserializer<SerialClob> {
        private ClobDeserializer() {
        }

        public SerialClob deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            try {
                return new SerialClob(p.getValueAsString().toCharArray());
            }
            catch (SQLException e) {
                LOGGER.error("deserialize java.sql.Clob error : {}", (Object)e.getMessage(), (Object)e);
                return null;
            }
        }
    }

    private static class ClobSerializer
    extends JsonSerializer<SerialClob> {
        private ClobSerializer() {
        }

        public void serializeWithType(SerialClob clob, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
            WritableTypeId typeIdDef = typeSer.writeTypePrefix(gen, typeSer.typeId((Object)clob, JsonToken.VALUE_EMBEDDED_OBJECT));
            this.serialize(clob, gen, serializers);
            typeSer.writeTypeSuffix(gen, typeIdDef);
        }

        public void serialize(SerialClob clob, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            try {
                gen.writeString(clob.getCharacterStream(), (int)clob.length());
            }
            catch (SerialException e) {
                LOGGER.error("serialize java.sql.Blob error : {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    private static class BlobDeserializer
    extends JsonDeserializer<SerialBlob> {
        private BlobDeserializer() {
        }

        public SerialBlob deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            try {
                return new SerialBlob(p.getBinaryValue());
            }
            catch (SQLException e) {
                LOGGER.error("deserialize java.sql.Blob error : {}", (Object)e.getMessage(), (Object)e);
                return null;
            }
        }
    }

    private static class BlobSerializer
    extends JsonSerializer<SerialBlob> {
        private BlobSerializer() {
        }

        public void serializeWithType(SerialBlob blob, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
            WritableTypeId typeIdDef = typeSer.writeTypePrefix(gen, typeSer.typeId((Object)blob, JsonToken.VALUE_EMBEDDED_OBJECT));
            this.serialize(blob, gen, serializers);
            typeSer.writeTypeSuffix(gen, typeIdDef);
        }

        public void serialize(SerialBlob blob, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            try {
                gen.writeBinary(blob.getBytes(1L, (int)blob.length()));
            }
            catch (SerialException e) {
                LOGGER.error("serialize java.sql.Blob error : {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    private static class TimestampDeserializer
    extends JsonDeserializer<Timestamp> {
        private TimestampDeserializer() {
        }

        public Timestamp deserialize(JsonParser p, DeserializationContext ctxt) {
            if (p.isExpectedStartArrayToken()) {
                try {
                    ArrayNode arrayNode = (ArrayNode)p.getCodec().readTree(p);
                    Timestamp timestamp = new Timestamp(arrayNode.get(0).asLong());
                    timestamp.setNanos(arrayNode.get(1).asInt());
                    return timestamp;
                }
                catch (IOException e) {
                    LOGGER.error("deserialize java.sql.Timestamp error : {}", (Object)e.getMessage(), (Object)e);
                }
            }
            LOGGER.error("deserialize java.sql.Timestamp type error.");
            return null;
        }
    }

    private static class TimestampSerializer
    extends JsonSerializer<Timestamp> {
        private TimestampSerializer() {
        }

        public void serializeWithType(Timestamp timestamp, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSerializer) throws IOException {
            WritableTypeId typeId = typeSerializer.writeTypePrefix(gen, typeSerializer.typeId((Object)timestamp, JsonToken.START_ARRAY));
            this.serialize(timestamp, gen, serializers);
            gen.writeTypeSuffix(typeId);
        }

        public void serialize(Timestamp timestamp, JsonGenerator gen, SerializerProvider serializers) {
            try {
                gen.writeNumber(timestamp.getTime());
                gen.writeNumber(timestamp.getNanos());
            }
            catch (IOException e) {
                LOGGER.error("serialize java.sql.Timestamp error : {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }
}

