/*
 * Decompiled with CFR 0.152.
 */
package io.seata.core.store.db;

import io.seata.common.exception.StoreException;
import io.seata.common.executor.Initialize;
import io.seata.common.util.StringUtils;
import io.seata.config.Configuration;
import io.seata.config.ConfigurationFactory;
import io.seata.core.constants.DBType;
import io.seata.core.store.db.DataSourceProvider;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import javax.sql.DataSource;

public abstract class AbstractDataSourceProvider
implements DataSourceProvider,
Initialize {
    private DataSource dataSource;
    protected static final Configuration CONFIG = ConfigurationFactory.getInstance();
    private static final String MYSQL_DRIVER_CLASS_NAME = "com.mysql.jdbc.Driver";
    private static final String MYSQL8_DRIVER_CLASS_NAME = "com.mysql.cj.jdbc.Driver";
    private static final String MYSQL_DRIVER_FILE_PREFIX = "mysql-connector-java-";
    private static final Map<String, ClassLoader> MYSQL_DRIVER_LOADERS = AbstractDataSourceProvider.createMysqlDriverClassLoaders();
    private static final int DEFAULT_DB_MAX_CONN = 20;
    private static final int DEFAULT_DB_MIN_CONN = 1;
    private static final long DEFAULT_DB_MAX_WAIT = 5000L;

    @Override
    public void init() {
        this.dataSource = this.generate();
    }

    @Override
    public DataSource provide() {
        return this.dataSource;
    }

    public abstract DataSource generate();

    protected DBType getDBType() {
        return DBType.valueof(CONFIG.getConfig("store.db.dbType"));
    }

    protected String getDriverClassName() {
        String driverClassName = CONFIG.getConfig("store.db.driverClassName");
        if (StringUtils.isBlank(driverClassName)) {
            throw new StoreException(String.format("the {%s} can't be empty", "store.db.driverClassName"));
        }
        return driverClassName;
    }

    protected Long getMaxWait() {
        Long maxWait = CONFIG.getLong("store.db.maxWait", 5000L);
        return maxWait;
    }

    protected ClassLoader getDriverClassLoader() {
        return MYSQL_DRIVER_LOADERS.getOrDefault(this.getDriverClassName(), ClassLoader.getSystemClassLoader());
    }

    private static Map<String, ClassLoader> createMysqlDriverClassLoaders() {
        HashMap<String, ClassLoader> loaders = new HashMap<String, ClassLoader>();
        String cp = System.getProperty("java.class.path");
        if (cp == null || cp.isEmpty()) {
            return loaders;
        }
        Stream.of(cp.split(File.pathSeparator)).map(File::new).filter(File::exists).map(file -> file.isFile() ? file.getParentFile() : file).filter(Objects::nonNull).filter(File::isDirectory).map(file -> new File((File)file, "jdbc")).filter(File::exists).filter(File::isDirectory).distinct().flatMap(file -> {
            File[] files = file.listFiles((f, name) -> name.startsWith(MYSQL_DRIVER_FILE_PREFIX));
            if (files != null) {
                return Stream.of(files);
            }
            return Stream.of(new File[0]);
        }).forEach(file -> {
            if (loaders.containsKey(MYSQL8_DRIVER_CLASS_NAME) && loaders.containsKey(MYSQL_DRIVER_CLASS_NAME)) {
                return;
            }
            try {
                URL url = file.toURI().toURL();
                URLClassLoader loader = new URLClassLoader(new URL[]{url}, ClassLoader.getSystemClassLoader());
                try {
                    loader.loadClass(MYSQL8_DRIVER_CLASS_NAME);
                    loaders.putIfAbsent(MYSQL8_DRIVER_CLASS_NAME, loader);
                }
                catch (ClassNotFoundException e) {
                    loaders.putIfAbsent(MYSQL_DRIVER_CLASS_NAME, loader);
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        });
        return loaders;
    }

    protected String getUrl() {
        String url = CONFIG.getConfig("store.db.url");
        if (StringUtils.isBlank(url)) {
            throw new StoreException(String.format("the {%s} can't be empty", "store.db.url"));
        }
        return url;
    }

    protected String getUser() {
        String user = CONFIG.getConfig("store.db.user");
        if (StringUtils.isBlank(user)) {
            throw new StoreException(String.format("the {%s} can't be empty", "store.db.user"));
        }
        return user;
    }

    protected String getPassword() {
        String password = CONFIG.getConfig("store.db.password");
        return password;
    }

    protected int getMinConn() {
        int minConn = CONFIG.getInt("store.db.minConn", 1);
        return minConn < 0 ? 1 : minConn;
    }

    protected int getMaxConn() {
        int maxConn = CONFIG.getInt("store.db.maxConn", 20);
        return maxConn < 0 ? 20 : maxConn;
    }

    protected String getValidationQuery(DBType dbType) {
        if (DBType.ORACLE.equals((Object)dbType)) {
            return "select sysdate from dual";
        }
        return "select 1";
    }
}

