/*
 * Decompiled with CFR 0.152.
 */
package io.seata.saga.proctrl.impl;

import io.seata.saga.proctrl.HierarchicalProcessContext;
import io.seata.saga.proctrl.Instruction;
import io.seata.saga.proctrl.ProcessContext;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ProcessContextImpl
implements HierarchicalProcessContext,
ProcessContext {
    private Map<String, Object> variables = new ConcurrentHashMap<String, Object>();
    private Instruction instruction;
    private ProcessContext parent;

    @Override
    public Object getVariable(String name) {
        if (this.variables.containsKey(name)) {
            return this.variables.get(name);
        }
        if (this.parent != null) {
            return this.parent.getVariable(name);
        }
        return null;
    }

    @Override
    public void setVariable(String name, Object value) {
        if (this.variables.containsKey(name)) {
            this.setVariableLocally(name, value);
        } else if (this.parent != null) {
            this.parent.setVariable(name, value);
        } else {
            this.setVariableLocally(name, value);
        }
    }

    @Override
    public Map<String, Object> getVariables() {
        HashMap<String, Object> collectedVariables = new HashMap<String, Object>();
        if (this.parent != null) {
            collectedVariables.putAll(this.parent.getVariables());
        }
        for (String name : this.variables.keySet()) {
            collectedVariables.put(name, this.variables.get(name));
        }
        return collectedVariables;
    }

    @Override
    public void setVariables(Map<String, Object> variables) {
        if (variables != null) {
            for (String name : variables.keySet()) {
                this.setVariable(name, variables.get(name));
            }
        }
    }

    @Override
    public Object getVariableLocally(String name) {
        return this.variables.get(name);
    }

    @Override
    public void setVariableLocally(String name, Object value) {
        this.variables.put(name, value);
    }

    @Override
    public Map<String, Object> getVariablesLocally() {
        return Collections.unmodifiableMap(this.variables);
    }

    @Override
    public void setVariablesLocally(Map<String, Object> variables) {
        this.variables.putAll(variables);
    }

    @Override
    public boolean hasVariable(String name) {
        if (this.variables.containsKey(name)) {
            return true;
        }
        if (this.parent != null) {
            return this.parent.hasVariable(name);
        }
        return false;
    }

    @Override
    public Instruction getInstruction() {
        return this.instruction;
    }

    @Override
    public void setInstruction(Instruction instruction) {
        this.instruction = instruction;
    }

    @Override
    public <T extends Instruction> T getInstruction(Class<T> clazz) {
        return (T)this.instruction;
    }

    @Override
    public boolean hasVariableLocal(String name) {
        return this.variables.containsKey(name);
    }

    @Override
    public Object removeVariable(String name) {
        if (this.variables.containsKey(name)) {
            return this.variables.remove(name);
        }
        if (this.parent != null) {
            return this.parent.removeVariable(name);
        }
        return null;
    }

    @Override
    public Object removeVariableLocally(String name) {
        return this.variables.remove(name);
    }

    @Override
    public void clearLocally() {
        this.variables.clear();
    }

    public ProcessContext getParent() {
        return this.parent;
    }

    public void setParent(ProcessContext parent) {
        this.parent = parent;
    }

    public String toString() {
        return "{variables=" + this.variables + ", instruction=" + this.instruction + ", parent=" + this.parent + '}';
    }
}

