/*
 * Decompiled with CFR 0.152.
 */
package io.seata.spring.annotation;

import io.seata.common.util.CollectionUtils;
import io.seata.common.util.StringUtils;
import io.seata.config.ConfigurationCache;
import io.seata.config.ConfigurationChangeListener;
import io.seata.config.ConfigurationFactory;
import io.seata.core.rpc.ShutdownHook;
import io.seata.core.rpc.netty.RmNettyRemotingClient;
import io.seata.core.rpc.netty.TmNettyRemotingClient;
import io.seata.rm.RMClient;
import io.seata.spring.annotation.GlobalLock;
import io.seata.spring.annotation.GlobalTransactional;
import io.seata.spring.annotation.GlobalTransactionalInterceptor;
import io.seata.spring.annotation.MethodDesc;
import io.seata.spring.tcc.TccActionInterceptor;
import io.seata.spring.util.SpringProxyUtils;
import io.seata.spring.util.TCCBeanParserUtils;
import io.seata.tm.TMClient;
import io.seata.tm.api.FailureHandler;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.aopalliance.intercept.MethodInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.Advisor;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.framework.autoproxy.AbstractAutoProxyCreator;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;

public class GlobalTransactionScanner
extends AbstractAutoProxyCreator
implements InitializingBean,
ApplicationContextAware,
DisposableBean {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalTransactionScanner.class);
    private static final int AT_MODE = 1;
    private static final int MT_MODE = 2;
    private static final int ORDER_NUM = 1024;
    private static final int DEFAULT_MODE = 3;
    private static final Set<String> PROXYED_SET = new HashSet<String>();
    private MethodInterceptor interceptor;
    private MethodInterceptor globalTransactionalInterceptor;
    private final String applicationId;
    private final String txServiceGroup;
    private final int mode;
    private final boolean disableGlobalTransaction = ConfigurationFactory.getInstance().getBoolean("service.disableGlobalTransaction", false);
    private final FailureHandler failureHandlerHook;
    private ApplicationContext applicationContext;

    public GlobalTransactionScanner(String txServiceGroup) {
        this(txServiceGroup, txServiceGroup, 3);
    }

    public GlobalTransactionScanner(String txServiceGroup, int mode) {
        this(txServiceGroup, txServiceGroup, mode);
    }

    public GlobalTransactionScanner(String applicationId, String txServiceGroup) {
        this(applicationId, txServiceGroup, 3);
    }

    public GlobalTransactionScanner(String applicationId, String txServiceGroup, int mode) {
        this(applicationId, txServiceGroup, mode, null);
    }

    public GlobalTransactionScanner(String applicationId, String txServiceGroup, FailureHandler failureHandlerHook) {
        this(applicationId, txServiceGroup, 3, failureHandlerHook);
    }

    public GlobalTransactionScanner(String applicationId, String txServiceGroup, int mode, FailureHandler failureHandlerHook) {
        this.setOrder(1024);
        this.setProxyTargetClass(true);
        this.applicationId = applicationId;
        this.txServiceGroup = txServiceGroup;
        this.mode = mode;
        this.failureHandlerHook = failureHandlerHook;
    }

    public void destroy() {
        ShutdownHook.getInstance().destroyAll();
    }

    private void initClient() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Initializing Global Transaction Clients ... ");
        }
        if (StringUtils.isNullOrEmpty(this.applicationId) || StringUtils.isNullOrEmpty(this.txServiceGroup)) {
            throw new IllegalArgumentException(String.format("applicationId: %s, txServiceGroup: %s", this.applicationId, this.txServiceGroup));
        }
        TMClient.init(this.applicationId, this.txServiceGroup);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Transaction Manager Client is initialized. applicationId[{}] txServiceGroup[{}]", (Object)this.applicationId, (Object)this.txServiceGroup);
        }
        RMClient.init(this.applicationId, this.txServiceGroup);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Resource Manager is initialized. applicationId[{}] txServiceGroup[{}]", (Object)this.applicationId, (Object)this.txServiceGroup);
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Global Transaction Clients are initialized. ");
        }
        this.registerSpringShutdownHook();
    }

    private void registerSpringShutdownHook() {
        if (this.applicationContext instanceof ConfigurableApplicationContext) {
            ((ConfigurableApplicationContext)this.applicationContext).registerShutdownHook();
            ShutdownHook.removeRuntimeShutdownHook();
        }
        ShutdownHook.getInstance().addDisposable(TmNettyRemotingClient.getInstance(this.applicationId, this.txServiceGroup));
        ShutdownHook.getInstance().addDisposable(RmNettyRemotingClient.getInstance(this.applicationId, this.txServiceGroup));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object wrapIfNecessary(Object bean, String beanName, Object cacheKey) {
        if (this.disableGlobalTransaction) {
            return bean;
        }
        try {
            Set<String> set = PROXYED_SET;
            synchronized (set) {
                if (PROXYED_SET.contains(beanName)) {
                    return bean;
                }
                this.interceptor = null;
                if (TCCBeanParserUtils.isTccAutoProxy(bean, beanName, this.applicationContext)) {
                    this.interceptor = new TccActionInterceptor(TCCBeanParserUtils.getRemotingDesc(beanName));
                } else {
                    Class<?> serviceInterface = SpringProxyUtils.findTargetClass(bean);
                    Class<?>[] interfacesIfJdk = SpringProxyUtils.findInterfaces(bean);
                    if (!this.existsAnnotation(new Class[]{serviceInterface}) && !this.existsAnnotation(interfacesIfJdk)) {
                        return bean;
                    }
                    if (this.interceptor == null) {
                        if (this.globalTransactionalInterceptor == null) {
                            this.globalTransactionalInterceptor = new GlobalTransactionalInterceptor(this.failureHandlerHook);
                            ConfigurationCache.addConfigListener("service.disableGlobalTransaction", (ConfigurationChangeListener)this.globalTransactionalInterceptor);
                        }
                        this.interceptor = this.globalTransactionalInterceptor;
                    }
                }
                LOGGER.info("Bean[{}] with name [{}] would use interceptor [{}]", new Object[]{bean.getClass().getName(), beanName, this.interceptor.getClass().getName()});
                if (!AopUtils.isAopProxy((Object)bean)) {
                    bean = super.wrapIfNecessary(bean, beanName, cacheKey);
                } else {
                    Advisor[] advisor;
                    AdvisedSupport advised = SpringProxyUtils.getAdvisedSupport(bean);
                    for (Advisor avr : advisor = this.buildAdvisors(beanName, this.getAdvicesAndAdvisorsForBean(null, null, null))) {
                        advised.addAdvisor(0, avr);
                    }
                }
                PROXYED_SET.add(beanName);
                return bean;
            }
        }
        catch (Exception exx) {
            throw new RuntimeException(exx);
        }
    }

    private boolean existsAnnotation(Class<?>[] classes) {
        if (CollectionUtils.isNotEmpty(classes)) {
            for (Class<?> clazz : classes) {
                Method[] methods;
                if (clazz == null) continue;
                GlobalTransactional trxAnno = clazz.getAnnotation(GlobalTransactional.class);
                if (trxAnno != null) {
                    return true;
                }
                for (Method method : methods = clazz.getMethods()) {
                    trxAnno = method.getAnnotation(GlobalTransactional.class);
                    if (trxAnno != null) {
                        return true;
                    }
                    GlobalLock lockAnno = method.getAnnotation(GlobalLock.class);
                    if (lockAnno == null) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private MethodDesc makeMethodDesc(GlobalTransactional anno, Method method) {
        return new MethodDesc(anno, method);
    }

    protected Object[] getAdvicesAndAdvisorsForBean(Class beanClass, String beanName, TargetSource customTargetSource) throws BeansException {
        return new Object[]{this.interceptor};
    }

    public void afterPropertiesSet() {
        if (this.disableGlobalTransaction) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Global transaction is disabled.");
            }
            return;
        }
        this.initClient();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        this.setBeanFactory((BeanFactory)applicationContext);
    }
}

