/*
 * Decompiled with CFR 0.152.
 */
package io.seata.tm.api;

import io.seata.common.util.StringUtils;
import io.seata.config.ConfigurationFactory;
import io.seata.core.context.RootContext;
import io.seata.core.exception.TransactionException;
import io.seata.core.model.GlobalStatus;
import io.seata.core.model.TransactionManager;
import io.seata.tm.TransactionManagerHolder;
import io.seata.tm.api.GlobalTransaction;
import io.seata.tm.api.GlobalTransactionRole;
import io.seata.tm.api.transaction.SuspendedResourcesHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultGlobalTransaction
implements GlobalTransaction {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultGlobalTransaction.class);
    private static final int DEFAULT_GLOBAL_TX_TIMEOUT = 60000;
    private static final String DEFAULT_GLOBAL_TX_NAME = "default";
    private TransactionManager transactionManager = TransactionManagerHolder.get();
    private String xid;
    private GlobalStatus status;
    private GlobalTransactionRole role;
    private static final int COMMIT_RETRY_COUNT = ConfigurationFactory.getInstance().getInt("client.tm.commitRetryCount", 5);
    private static final int ROLLBACK_RETRY_COUNT = ConfigurationFactory.getInstance().getInt("client.tm.rollbackRetryCount", 5);

    DefaultGlobalTransaction() {
        this(null, GlobalStatus.UnKnown, GlobalTransactionRole.Launcher);
    }

    DefaultGlobalTransaction(String xid, GlobalStatus status, GlobalTransactionRole role) {
        this.xid = xid;
        this.status = status;
        this.role = role;
    }

    @Override
    public void begin() throws TransactionException {
        this.begin(60000);
    }

    @Override
    public void begin(int timeout) throws TransactionException {
        this.begin(timeout, DEFAULT_GLOBAL_TX_NAME);
    }

    @Override
    public void begin(int timeout, String name) throws TransactionException {
        if (this.role != GlobalTransactionRole.Launcher) {
            this.assertXIDNotNull();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Ignore Begin(): just involved in global transaction [{}]", (Object)this.xid);
            }
            return;
        }
        this.assertXIDNull();
        if (RootContext.getXID() != null) {
            throw new IllegalStateException();
        }
        this.xid = this.transactionManager.begin(null, null, name, timeout);
        this.status = GlobalStatus.Begin;
        RootContext.bind(this.xid);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Begin new global transaction [{}]", (Object)this.xid);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void commit() throws TransactionException {
        if (this.role == GlobalTransactionRole.Participant) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Ignore Commit(): just involved in global transaction [{}]", (Object)this.xid);
            }
            return;
        }
        this.assertXIDNotNull();
        int retry = COMMIT_RETRY_COUNT <= 0 ? 5 : COMMIT_RETRY_COUNT;
        try {
            while (retry > 0) {
                try {
                    this.status = this.transactionManager.commit(this.xid);
                    break;
                }
                catch (Throwable ex) {
                    LOGGER.error("Failed to report global commit [{}],Retry Countdown: {}, reason: {}", new Object[]{this.getXid(), retry, ex.getMessage()});
                    if (--retry != 0) continue;
                    throw new TransactionException("Failed to report global commit", ex);
                }
            }
        }
        finally {
            if (RootContext.getXID() != null && this.xid.equals(RootContext.getXID())) {
                this.suspend(true);
            }
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("[{}] commit status: {}", (Object)this.xid, (Object)this.status);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void rollback() throws TransactionException {
        if (this.role == GlobalTransactionRole.Participant) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Ignore Rollback(): just involved in global transaction [{}]", (Object)this.xid);
            }
            return;
        }
        this.assertXIDNotNull();
        int retry = ROLLBACK_RETRY_COUNT <= 0 ? 5 : ROLLBACK_RETRY_COUNT;
        try {
            while (retry > 0) {
                try {
                    this.status = this.transactionManager.rollback(this.xid);
                    break;
                }
                catch (Throwable ex) {
                    LOGGER.error("Failed to report global rollback [{}],Retry Countdown: {}, reason: {}", new Object[]{this.getXid(), retry, ex.getMessage()});
                    if (--retry != 0) continue;
                    throw new TransactionException("Failed to report global rollback", ex);
                }
            }
        }
        finally {
            if (RootContext.getXID() != null && this.xid.equals(RootContext.getXID())) {
                this.suspend(true);
            }
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("[{}] rollback status: {}", (Object)this.xid, (Object)this.status);
        }
    }

    @Override
    public SuspendedResourcesHolder suspend(boolean unbindXid) throws TransactionException {
        String xid = RootContext.getXID();
        if (StringUtils.isNotEmpty(xid) && unbindXid) {
            RootContext.unbind();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Suspending current transaction,xid = {}", (Object)xid);
            }
        } else {
            xid = null;
        }
        return new SuspendedResourcesHolder(xid);
    }

    @Override
    public void resume(SuspendedResourcesHolder suspendedResourcesHolder) throws TransactionException {
        if (suspendedResourcesHolder == null) {
            return;
        }
        String xid = suspendedResourcesHolder.getXid();
        if (StringUtils.isNotEmpty(xid)) {
            RootContext.bind(xid);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Resumimg the transaction,xid = {}", (Object)xid);
            }
        }
    }

    @Override
    public GlobalStatus getStatus() throws TransactionException {
        if (this.xid == null) {
            return GlobalStatus.UnKnown;
        }
        this.status = this.transactionManager.getStatus(this.xid);
        return this.status;
    }

    @Override
    public String getXid() {
        return this.xid;
    }

    @Override
    public void globalReport(GlobalStatus globalStatus) throws TransactionException {
        this.assertXIDNotNull();
        if (globalStatus == null) {
            throw new IllegalStateException();
        }
        this.status = this.transactionManager.globalReport(this.xid, globalStatus);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("[{}] report status: {}", (Object)this.xid, (Object)this.status);
        }
        if (RootContext.getXID() != null && this.xid.equals(RootContext.getXID())) {
            this.suspend(true);
        }
    }

    @Override
    public GlobalStatus getLocalStatus() {
        return this.status;
    }

    private void assertXIDNotNull() {
        if (this.xid == null) {
            throw new IllegalStateException();
        }
    }

    private void assertXIDNull() {
        if (this.xid != null) {
            throw new IllegalStateException();
        }
    }
}

