/*
 * Decompiled with CFR 0.152.
 */
package io.seata.core.rpc.netty;

import io.netty.channel.ServerChannel;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.seata.core.rpc.netty.NettyBaseConfig;

public class NettyServerConfig
extends NettyBaseConfig {
    private int serverSelectorThreads = Integer.parseInt(System.getProperty("transport.serverSelectorThreads", String.valueOf(WORKER_THREAD_SIZE)));
    private int serverSocketSendBufSize = Integer.parseInt(System.getProperty("transport.serverSocketSendBufSize", String.valueOf(153600)));
    private int serverSocketResvBufSize = Integer.parseInt(System.getProperty("transport.serverSocketResvBufSize", String.valueOf(153600)));
    private int serverWorkerThreads = Integer.parseInt(System.getProperty("transport.serverWorkerThreads", String.valueOf(WORKER_THREAD_SIZE)));
    private int soBackLogSize = Integer.parseInt(System.getProperty("transport.soBackLogSize", String.valueOf(1024)));
    private int writeBufferHighWaterMark = Integer.parseInt(System.getProperty("transport.writeBufferHighWaterMark", String.valueOf(0x4000000)));
    private int writeBufferLowWaterMark = Integer.parseInt(System.getProperty("transport.writeBufferLowWaterMark", String.valueOf(0x100000)));
    private static final int DEFAULT_LISTEN_PORT = 8091;
    private static final int RPC_REQUEST_TIMEOUT = 30000;
    private int serverChannelMaxIdleTimeSeconds = Integer.parseInt(System.getProperty("transport.serverChannelMaxIdleTimeSeconds", String.valueOf(30)));
    private static final String EPOLL_WORKER_THREAD_PREFIX = "NettyServerEPollWorker";
    private static int minServerPoolSize = Integer.parseInt(System.getProperty("transport.minServerPoolSize", "50"));
    private static int maxServerPoolSize = Integer.parseInt(System.getProperty("transport.maxServerPoolSize", "500"));
    private static int maxTaskQueueSize = Integer.parseInt(System.getProperty("transport.maxTaskQueueSize", "20000"));
    private static int keepAliveTime = Integer.parseInt(System.getProperty("transport.keepAliveTime", "500"));
    public static final Class<? extends ServerChannel> SERVER_CHANNEL_CLAZZ = NettyBaseConfig.SERVER_CHANNEL_CLAZZ;

    public int getServerSelectorThreads() {
        return this.serverSelectorThreads;
    }

    public void setServerSelectorThreads(int serverSelectorThreads) {
        this.serverSelectorThreads = serverSelectorThreads;
    }

    public static boolean enableEpoll() {
        return NettyBaseConfig.SERVER_CHANNEL_CLAZZ.equals(EpollServerSocketChannel.class) && Epoll.isAvailable();
    }

    public int getServerSocketSendBufSize() {
        return this.serverSocketSendBufSize;
    }

    public void setServerSocketSendBufSize(int serverSocketSendBufSize) {
        this.serverSocketSendBufSize = serverSocketSendBufSize;
    }

    public int getServerSocketResvBufSize() {
        return this.serverSocketResvBufSize;
    }

    public void setServerSocketResvBufSize(int serverSocketResvBufSize) {
        this.serverSocketResvBufSize = serverSocketResvBufSize;
    }

    public int getServerWorkerThreads() {
        return this.serverWorkerThreads;
    }

    public void setServerWorkerThreads(int serverWorkerThreads) {
        this.serverWorkerThreads = serverWorkerThreads;
    }

    public int getSoBackLogSize() {
        return this.soBackLogSize;
    }

    public void setSoBackLogSize(int soBackLogSize) {
        this.soBackLogSize = soBackLogSize;
    }

    public int getWriteBufferHighWaterMark() {
        return this.writeBufferHighWaterMark;
    }

    public void setWriteBufferHighWaterMark(int writeBufferHighWaterMark) {
        this.writeBufferHighWaterMark = writeBufferHighWaterMark;
    }

    public int getWriteBufferLowWaterMark() {
        return this.writeBufferLowWaterMark;
    }

    public void setWriteBufferLowWaterMark(int writeBufferLowWaterMark) {
        this.writeBufferLowWaterMark = writeBufferLowWaterMark;
    }

    public int getDefaultListenPort() {
        return 8091;
    }

    public int getChannelMaxReadIdleSeconds() {
        return MAX_READ_IDLE_SECONDS;
    }

    public int getServerChannelMaxIdleTimeSeconds() {
        return this.serverChannelMaxIdleTimeSeconds;
    }

    public static int getRpcRequestTimeout() {
        return 30000;
    }

    public String getBossThreadPrefix() {
        return CONFIG.getConfig("transport.threadFactory.bossThreadPrefix", "NettyBoss");
    }

    public String getWorkerThreadPrefix() {
        return CONFIG.getConfig("transport.threadFactory.workerThreadPrefix", NettyServerConfig.enableEpoll() ? EPOLL_WORKER_THREAD_PREFIX : "NettyServerNIOWorker");
    }

    public String getExecutorThreadPrefix() {
        return CONFIG.getConfig("transport.threadFactory.serverExecutorThreadPrefix", "NettyServerBizHandler");
    }

    public int getBossThreadSize() {
        return CONFIG.getInt("transport.threadFactory.bossThreadSize", 1);
    }

    public int getServerShutdownWaitTime() {
        return CONFIG.getInt("transport.shutdown.wait", 3);
    }

    public static int getMinServerPoolSize() {
        return minServerPoolSize;
    }

    public static int getMaxServerPoolSize() {
        return maxServerPoolSize;
    }

    public static int getMaxTaskQueueSize() {
        return maxTaskQueueSize;
    }

    public static int getKeepAliveTime() {
        return keepAliveTime;
    }
}

