/*
 * Decompiled with CFR 0.152.
 */
package io.seata.common.util;

import io.seata.common.util.StringUtils;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetUtil.class);
    private static final String LOCALHOST = "127.0.0.1";
    private static final String ANY_HOST = "0.0.0.0";
    private static volatile InetAddress LOCAL_ADDRESS = null;
    private static final Pattern IP_PATTERN = Pattern.compile("\\d{1,3}(\\.\\d{1,3}){3,5}$");

    public static String toStringAddress(SocketAddress address) {
        if (address == null) {
            return "";
        }
        return NetUtil.toStringAddress((InetSocketAddress)address);
    }

    public static String toIpAddress(SocketAddress address) {
        InetSocketAddress inetSocketAddress = (InetSocketAddress)address;
        return inetSocketAddress.getAddress().getHostAddress();
    }

    public static String toStringAddress(InetSocketAddress address) {
        return address.getAddress().getHostAddress() + ":" + address.getPort();
    }

    public static InetSocketAddress toInetSocketAddress(String address) {
        int port;
        String host;
        int i = address.indexOf(58);
        if (i > -1) {
            host = address.substring(0, i);
            port = Integer.parseInt(address.substring(i + 1));
        } else {
            host = address;
            port = 0;
        }
        return new InetSocketAddress(host, port);
    }

    public static long toLong(String address) {
        InetSocketAddress ad = NetUtil.toInetSocketAddress(address);
        String[] ip = ad.getAddress().getHostAddress().split("\\.");
        long r = 0L;
        r |= Long.parseLong(ip[0]) << 40;
        r |= Long.parseLong(ip[1]) << 32;
        r |= Long.parseLong(ip[2]) << 24;
        r |= Long.parseLong(ip[3]) << 16;
        return r |= (long)ad.getPort();
    }

    public static String getLocalIp(String ... preferredNetworks) {
        InetAddress address = NetUtil.getLocalAddress(preferredNetworks);
        return address == null ? LOCALHOST : address.getHostAddress();
    }

    public static String getLocalHost() {
        InetAddress address = NetUtil.getLocalAddress(new String[0]);
        return address == null ? "localhost" : address.getHostName();
    }

    public static InetAddress getLocalAddress(String ... preferredNetworks) {
        InetAddress localAddress;
        if (LOCAL_ADDRESS != null) {
            return LOCAL_ADDRESS;
        }
        LOCAL_ADDRESS = localAddress = NetUtil.getLocalAddress0(preferredNetworks);
        return localAddress;
    }

    private static InetAddress getLocalAddress0(String ... preferredNetworks) {
        InetAddress localAddress;
        block13: {
            localAddress = null;
            try {
                Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
                if (interfaces == null) break block13;
                while (interfaces.hasMoreElements()) {
                    try {
                        NetworkInterface network = interfaces.nextElement();
                        if (!network.isUp()) continue;
                        Enumeration<InetAddress> addresses = network.getInetAddresses();
                        while (addresses.hasMoreElements()) {
                            try {
                                InetAddress address = addresses.nextElement();
                                if (!NetUtil.isValidAddress(address)) continue;
                                if (null == localAddress) {
                                    localAddress = address;
                                }
                                if (preferredNetworks.length > 0) {
                                    String ip = address.getHostAddress();
                                    for (String regex : preferredNetworks) {
                                        if (StringUtils.isBlank(regex) || !ip.matches(regex) && !ip.startsWith(regex)) continue;
                                        return address;
                                    }
                                    continue;
                                }
                                return address;
                            }
                            catch (Throwable e) {
                                LOGGER.warn("Failed to retrieving ip address, {}", (Object)e.getMessage(), (Object)e);
                            }
                        }
                    }
                    catch (Throwable e) {
                        LOGGER.warn("Failed to retrieving ip address, {}", (Object)e.getMessage(), (Object)e);
                    }
                }
            }
            catch (Throwable e) {
                LOGGER.warn("Failed to retrieving ip address, {}", (Object)e.getMessage(), (Object)e);
            }
        }
        if (localAddress == null) {
            LOGGER.error("Could not get local host ip address, will use 127.0.0.1 instead.");
        } else {
            LOGGER.error("Could not match ip by preferredNetworks:{}, will use default first ip {} instead.", (Object)Arrays.toString(preferredNetworks), (Object)localAddress.getHostAddress());
        }
        return localAddress;
    }

    public static void validAddress(InetSocketAddress address) {
        if (address.getHostName() == null || 0 == address.getPort()) {
            throw new IllegalArgumentException("invalid address:" + address);
        }
    }

    private static boolean isValidAddress(InetAddress address) {
        if (address == null || address.isLoopbackAddress()) {
            return false;
        }
        return NetUtil.isValidIp(address.getHostAddress(), false);
    }

    public static boolean isValidIp(String ip, boolean validLocalAndAny) {
        if (ip == null) {
            return false;
        }
        ip = NetUtil.convertIpIfNecessary(ip);
        if (validLocalAndAny) {
            return IP_PATTERN.matcher(ip).matches();
        }
        return !ANY_HOST.equals(ip) && !LOCALHOST.equals(ip) && IP_PATTERN.matcher(ip).matches();
    }

    private static String convertIpIfNecessary(String ip) {
        if (IP_PATTERN.matcher(ip).matches()) {
            return ip;
        }
        try {
            return InetAddress.getByName(ip).getHostAddress();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }
}

