/*
 * Decompiled with CFR 0.152.
 */
package io.seata.common.util;

import io.seata.common.exception.NotSupportYetException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;

public class PageUtil {
    public static final int MIN_PAGE_NUM = 1;
    public static final int MAX_PAGE_NUM = 999;
    public static final int MIN_PAGE_SIZE = 1;
    public static final int MAX_PAGE_SIZE = 100;
    private static final String SOURCE_SQL_PLACE_HOLD = " #sourcesql# ";
    private static final String LIMIT_PLACE_HOLD = " #limit# ";
    private static final String OFFSET_PLACE_HOLD = " #offset# ";
    private static final String START_PLACE_HOLD = " #start# ";
    private static final String END_PLACE_HOLD = " #end# ";
    private static final String LIMIT_TEMPLATE = " #sourcesql#  limit  #limit#  offset  #offset# ";
    private static final String ORACLE_PAGE_TEMPLATE = "select * from ( select ROWNUM rn, temp.* from ( #sourcesql# ) temp ) where rn between  #start#  and  #end# ";

    public static void checkParam(int pageNum, int pageSize) {
        if (pageNum < 1 || pageNum > 999) {
            throw new IllegalArgumentException("pageNum range not in [1-999]");
        }
        if (pageSize < 1 || pageSize > 100) {
            throw new IllegalArgumentException("pageSize range not in [1-100]");
        }
    }

    public static String pageSql(String sourceSql, String dbType, int pageNum, int pageSize) {
        switch (dbType) {
            case "mysql": 
            case "h2": 
            case "postgresql": 
            case "oceanbase": {
                return LIMIT_TEMPLATE.replace(SOURCE_SQL_PLACE_HOLD, sourceSql).replace(LIMIT_PLACE_HOLD, String.valueOf(pageSize)).replace(OFFSET_PLACE_HOLD, String.valueOf((pageNum - 1) * pageSize));
            }
            case "oracle": {
                return ORACLE_PAGE_TEMPLATE.replace(SOURCE_SQL_PLACE_HOLD, sourceSql).replace(START_PLACE_HOLD, String.valueOf(pageSize * (pageNum - 1) + 1)).replace(END_PLACE_HOLD, String.valueOf(pageSize * pageNum));
            }
        }
        throw new NotSupportYetException("PageUtil not support this dbType:" + dbType);
    }

    public static String countSql(String sourceSql, String dbType) {
        switch (dbType) {
            case "mysql": 
            case "h2": 
            case "postgresql": 
            case "oceanbase": 
            case "oracle": {
                return sourceSql.replaceAll("(?i)(?<=select)(.*)(?=from)", " count(1) ");
            }
        }
        throw new NotSupportYetException("PageUtil not support this dbType:" + dbType);
    }

    public static void setObject(PreparedStatement ps, List<Object> sqlParamList) throws SQLException {
        for (int i = 0; i < sqlParamList.size(); ++i) {
            if (sqlParamList.get(i) instanceof Date) {
                ps.setDate(i + 1, new java.sql.Date(((Date)sqlParamList.get(i)).getTime()));
                continue;
            }
            ps.setObject(i + 1, sqlParamList.get(i));
        }
    }
}

