/*
 * Decompiled with CFR 0.152.
 */
package io.seata.config.file;

import io.seata.common.loader.LoadLevel;
import io.seata.common.loader.Scope;
import io.seata.config.file.FileConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

@LoadLevel(name="YAML", order=1, scope=Scope.PROTOTYPE)
public class YamlFileConfig
implements FileConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(YamlFileConfig.class);
    private Map configMap;

    public YamlFileConfig(File file, String name) throws IOException {
        Yaml yaml = new Yaml();
        try (FileInputStream is = new FileInputStream(file);){
            this.configMap = (Map)yaml.load((InputStream)is);
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("file not found");
        }
    }

    @Override
    public String getString(String path) {
        try {
            Map config = this.configMap;
            String[] dataId = path.split("\\.");
            for (int i = 0; i < dataId.length - 1; ++i) {
                if (!config.containsKey(dataId[i])) {
                    return null;
                }
                config = (Map)config.get(dataId[i]);
            }
            Object value = config.get(dataId[dataId.length - 1]);
            return value == null ? null : String.valueOf(value);
        }
        catch (Exception e) {
            LOGGER.warn("get config data error" + path, (Throwable)e);
            return null;
        }
    }
}

