/*
 * Decompiled with CFR 0.152.
 */
package io.seata.core.logger;

import io.seata.common.util.CollectionUtils;
import io.seata.config.Configuration;
import io.seata.config.ConfigurationFactory;
import java.util.Arrays;
import java.util.concurrent.ThreadLocalRandom;
import org.slf4j.Logger;

public final class StackTraceLogger {
    private static final Configuration CONFIG = ConfigurationFactory.getInstance();
    private static final String STACK_TRACE_LOGGER_PREFIX = "[stacktrace]";

    public static void info(Logger logger, Throwable cause, String format, Object[] args) {
        if (logger.isInfoEnabled()) {
            if (StackTraceLogger.needToPrintStackTrace()) {
                logger.info(STACK_TRACE_LOGGER_PREFIX + format, StackTraceLogger.buildNewArgs(args, cause));
            } else {
                logger.info(format, args);
            }
        }
    }

    public static void warn(Logger logger, Throwable cause, String format, Object[] args) {
        if (logger.isWarnEnabled()) {
            if (StackTraceLogger.needToPrintStackTrace()) {
                logger.warn(STACK_TRACE_LOGGER_PREFIX + format, StackTraceLogger.buildNewArgs(args, cause));
            } else {
                logger.warn(format, args);
            }
        }
    }

    public static void error(Logger logger, Throwable cause, String format, Object[] args) {
        if (logger.isErrorEnabled()) {
            if (StackTraceLogger.needToPrintStackTrace()) {
                logger.error(STACK_TRACE_LOGGER_PREFIX + format, StackTraceLogger.buildNewArgs(args, cause));
            } else {
                logger.error(format, args);
            }
        }
    }

    private static int getRate() {
        return CONFIG.getInt("log.exceptionRate", 100);
    }

    private static boolean needToPrintStackTrace() {
        int rate = StackTraceLogger.getRate();
        return ThreadLocalRandom.current().nextInt(rate) == 0;
    }

    private static Object[] buildNewArgs(Object[] args, Throwable cause) {
        if (CollectionUtils.isEmpty(args)) {
            return new Object[]{cause};
        }
        Object[] newArgs = Arrays.copyOf(args, args.length + 1, Object[].class);
        newArgs[args.length] = cause;
        return newArgs;
    }
}

