/*
 * Decompiled with CFR 0.152.
 */
package io.seata.integration.sofa.rpc;

import com.alipay.sofa.rpc.context.RpcInternalContext;
import com.alipay.sofa.rpc.core.exception.SofaRpcException;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import com.alipay.sofa.rpc.ext.Extension;
import com.alipay.sofa.rpc.filter.AutoActive;
import com.alipay.sofa.rpc.filter.Filter;
import com.alipay.sofa.rpc.filter.FilterInvoker;
import io.seata.core.context.RootContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension(value="transactionContextConsumer")
@AutoActive(consumerSide=true)
public class TransactionContextConsumerFilter
extends Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransactionContextConsumerFilter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SofaResponse invoke(FilterInvoker filterInvoker, SofaRequest sofaRequest) throws SofaRpcException {
        String xid = RootContext.getXID();
        String rpcXid = this.getRpcXid();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("xid in RootContext[" + xid + "] xid in RpcContext[" + rpcXid + "]");
        }
        boolean bind = false;
        if (xid != null) {
            sofaRequest.addRequestProp("TX_XID", (Object)xid);
        } else if (rpcXid != null) {
            RootContext.bind(rpcXid);
            bind = true;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("bind[" + rpcXid + "] to RootContext");
            }
        }
        try {
            SofaResponse sofaResponse = filterInvoker.invoke(sofaRequest);
            return sofaResponse;
        }
        finally {
            if (bind) {
                String unbindXid = RootContext.unbind();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("unbind[" + unbindXid + "] from RootContext");
                }
                if (!rpcXid.equalsIgnoreCase(unbindXid)) {
                    if (LOGGER.isWarnEnabled()) {
                        LOGGER.warn("xid in change during RPC from " + rpcXid + " to " + unbindXid);
                    }
                    if (unbindXid != null) {
                        RootContext.bind(unbindXid);
                        if (LOGGER.isWarnEnabled()) {
                            LOGGER.warn("bind [" + unbindXid + "] back to RootContext");
                        }
                    }
                }
            }
        }
    }

    private String getRpcXid() {
        String rpcXid = (String)RpcInternalContext.getContext().getAttachment(".TX_XID");
        if (rpcXid == null) {
            rpcXid = (String)RpcInternalContext.getContext().getAttachment(".TX_XID".toLowerCase());
        }
        return rpcXid;
    }
}

