/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.tcc.remoting.parser;

import io.seata.common.exception.FrameworkException;
import io.seata.common.util.ReflectionUtil;
import io.seata.rm.tcc.api.LocalTCC;
import io.seata.rm.tcc.remoting.RemotingDesc;
import io.seata.rm.tcc.remoting.parser.AbstractedRemotingParser;
import java.util.Set;
import org.springframework.aop.framework.AopProxyUtils;

public class LocalTCCRemotingParser
extends AbstractedRemotingParser {
    @Override
    public boolean isReference(Object bean, String beanName) {
        return this.isLocalTCC(bean);
    }

    @Override
    public boolean isService(Object bean, String beanName) {
        return this.isLocalTCC(bean);
    }

    @Override
    public RemotingDesc getServiceDesc(Object bean, String beanName) throws FrameworkException {
        if (!this.isRemoting(bean, beanName)) {
            return null;
        }
        RemotingDesc remotingDesc = new RemotingDesc();
        remotingDesc.setReference(true);
        remotingDesc.setProtocol((short)5);
        Class<?> classType = bean.getClass();
        if (classType.isAnnotationPresent(LocalTCC.class)) {
            remotingDesc.setServiceClass(AopProxyUtils.ultimateTargetClass((Object)bean));
            remotingDesc.setServiceClassName(remotingDesc.getServiceClass().getName());
            remotingDesc.setTargetBean(bean);
            return remotingDesc;
        }
        Set<Class<?>> interfaceClasses = ReflectionUtil.getInterfaces(classType);
        for (Class<?> interClass : interfaceClasses) {
            if (!interClass.isAnnotationPresent(LocalTCC.class)) continue;
            remotingDesc.setServiceClassName(interClass.getName());
            remotingDesc.setServiceClass(interClass);
            remotingDesc.setTargetBean(bean);
            return remotingDesc;
        }
        throw new FrameworkException("Couldn't parser any Remoting info");
    }

    @Override
    public short getProtocol() {
        return 5;
    }

    private boolean isLocalTCC(Object bean) {
        Class<?> classType = bean.getClass();
        Set<Class<?>> interfaceClasses = ReflectionUtil.getInterfaces(classType);
        for (Class<?> interClass : interfaceClasses) {
            if (!interClass.isAnnotationPresent(LocalTCC.class)) continue;
            return true;
        }
        return classType.isAnnotationPresent(LocalTCC.class);
    }
}

