/*
 * Decompiled with CFR 0.152.
 */
package io.seata.serializer.seata.protocol;

import io.seata.serializer.seata.MessageSeataCodec;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMessageCodec
implements MessageSeataCodec {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractMessageCodec.class);
    protected static final Charset UTF8 = StandardCharsets.UTF_8;

    public static int bytesToInt(byte[] bytes, int offset) {
        int ret = 0;
        for (int i = 0; i < 4 && i + offset < bytes.length; ++i) {
            ret <<= 8;
            ret |= bytes[i + offset] & 0xFF;
        }
        return ret;
    }

    public static void intToBytes(int i, byte[] bytes, int offset) {
        bytes[offset] = (byte)(i >> 24 & 0xFF);
        bytes[offset + 1] = (byte)(i >> 16 & 0xFF);
        bytes[offset + 2] = (byte)(i >> 8 & 0xFF);
        bytes[offset + 3] = (byte)(i & 0xFF);
    }
}

