/*
 * Decompiled with CFR 0.152.
 */
package io.seata.integration.tx.api.interceptor;

import io.seata.common.exception.FrameworkException;
import io.seata.common.exception.SkipCallbackWrapperException;
import io.seata.common.executor.Callback;
import io.seata.common.util.CollectionUtils;
import io.seata.common.util.NetUtil;
import io.seata.integration.tx.api.fence.DefaultCommonFenceHandler;
import io.seata.integration.tx.api.interceptor.ActionContextUtil;
import io.seata.integration.tx.api.interceptor.TwoPhaseBusinessActionParam;
import io.seata.integration.tx.api.util.JsonUtil;
import io.seata.rm.DefaultResourceManager;
import io.seata.rm.tcc.api.BusinessActionContext;
import io.seata.rm.tcc.api.BusinessActionContextParameter;
import io.seata.rm.tcc.api.BusinessActionContextUtil;
import io.seata.rm.tcc.api.ParamType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class ActionInterceptorHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActionInterceptorHandler.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object proceed(Method method, Object[] arguments, String xid, TwoPhaseBusinessActionParam businessActionParam, Callback<Object> targetCallback) throws Throwable {
        BusinessActionContext actionContext = this.getOrCreateActionContextAndResetToArguments(method.getParameterTypes(), arguments);
        actionContext.setXid(xid);
        String actionName = businessActionParam.getActionName();
        actionContext.setActionName(actionName);
        actionContext.setDelayReport(businessActionParam.getDelayReport());
        actionContext.setBranchType(businessActionParam.getBranchType());
        String branchId = this.doTxActionLogStore(method, arguments, businessActionParam, actionContext);
        actionContext.setBranchId(branchId);
        MDC.put((String)"X-TX-BRANCH-ID", (String)branchId);
        BusinessActionContext previousActionContext = BusinessActionContextUtil.getContext();
        try {
            BusinessActionContextUtil.setContext(actionContext);
            if (businessActionParam.getUseCommonFence().booleanValue()) {
                try {
                    Object object = DefaultCommonFenceHandler.get().prepareFence(xid, Long.valueOf(branchId), actionName, targetCallback);
                    return object;
                }
                catch (SkipCallbackWrapperException | UndeclaredThrowableException e) {
                    Throwable originException = e.getCause();
                    if (originException instanceof FrameworkException) {
                        LOGGER.error("[{}] prepare common fence error: {}", (Object)xid, (Object)originException.getMessage());
                    }
                    throw originException;
                }
            }
            Object object = targetCallback.execute();
            return object;
        }
        finally {
            try {
                BusinessActionContextUtil.reportContext(actionContext);
            }
            finally {
                if (previousActionContext != null) {
                    BusinessActionContextUtil.setContext(previousActionContext);
                } else {
                    BusinessActionContextUtil.clear();
                }
            }
        }
    }

    @Nonnull
    protected BusinessActionContext getOrCreateActionContextAndResetToArguments(Class<?>[] parameterTypes, Object[] arguments) {
        BusinessActionContext actionContext = null;
        int argIndex = 0;
        for (Class<?> parameterType : parameterTypes) {
            if (BusinessActionContext.class.isAssignableFrom(parameterType)) {
                actionContext = (BusinessActionContext)arguments[argIndex];
                if (actionContext == null) {
                    actionContext = new BusinessActionContext();
                    arguments[argIndex] = actionContext;
                    break;
                }
                actionContext.setUpdated(null);
                break;
            }
            ++argIndex;
        }
        if (actionContext == null) {
            actionContext = new BusinessActionContext();
        }
        return actionContext;
    }

    protected String doTxActionLogStore(Method method, Object[] arguments, TwoPhaseBusinessActionParam businessActionParam, BusinessActionContext actionContext) {
        String actionName = actionContext.getActionName();
        String xid = actionContext.getXid();
        Map<String, Object> context = this.fetchActionRequestContext(method, arguments);
        context.put("action-start-time", System.currentTimeMillis());
        this.initBusinessContext(context, method, businessActionParam.getBusinessActionContext());
        this.initFrameworkContext(context);
        Map<String, Object> originContext = actionContext.getActionContext();
        if (CollectionUtils.isNotEmpty(originContext)) {
            originContext.putAll(context);
            context = originContext;
        } else {
            actionContext.setActionContext(context);
        }
        Map<String, Map<String, Object>> applicationContext = Collections.singletonMap("actionContext", context);
        String applicationContextStr = JsonUtil.toJSONString(applicationContext);
        try {
            Long branchId = DefaultResourceManager.get().branchRegister(businessActionParam.getBranchType(), actionName, null, xid, applicationContextStr, null);
            return String.valueOf(branchId);
        }
        catch (Throwable t) {
            String msg = String.format("%s branch Register error, xid: %s", new Object[]{businessActionParam.getBranchType(), xid});
            LOGGER.error(msg, t);
            throw new FrameworkException(t, msg);
        }
    }

    protected void initFrameworkContext(Map<String, Object> context) {
        try {
            context.put("host-name", NetUtil.getLocalIp(new String[0]));
        }
        catch (Throwable t) {
            LOGGER.warn("getLocalIP error", t);
        }
    }

    protected void initBusinessContext(Map<String, Object> context, Method method, Map<String, Object> businessActionContext) {
        if (method != null) {
            context.put("sys::prepare", method.getName());
        }
        if (businessActionContext != null && businessActionContext.size() > 0) {
            context.putAll(businessActionContext);
        }
    }

    protected Map<String, Object> fetchActionRequestContext(Method method, Object[] arguments) {
        HashMap<String, Object> context = new HashMap<String, Object>(8);
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            for (int j = 0; j < parameterAnnotations[i].length; ++j) {
                if (!(parameterAnnotations[i][j] instanceof BusinessActionContextParameter)) continue;
                BusinessActionContextParameter annotation = (BusinessActionContextParameter)parameterAnnotations[i][j];
                if (arguments[i] == null) {
                    throw new IllegalArgumentException("@BusinessActionContextParameter 's params can not null");
                }
                Object paramObject = arguments[i];
                if (paramObject == null) continue;
                ActionContextUtil.loadParamByAnnotationAndPutToContext(ParamType.PARAM, "", paramObject, annotation, context);
            }
        }
        return context;
    }
}

