/*
 * Decompiled with CFR 0.152.
 */
package io.seata.common.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class ReflectionUtil {
    public static final int MAX_NEST_DEPTH = 20;

    public static Class<?> getClassByName(String className) throws ClassNotFoundException {
        return Class.forName(className, true, Thread.currentThread().getContextClassLoader());
    }

    public static Object getFieldValue(Object target, String fieldName) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        int i = 0;
        for (Class<?> cl = target.getClass(); i++ < 20 && cl != null; cl = cl.getSuperclass()) {
            try {
                Field field = cl.getDeclaredField(fieldName);
                field.setAccessible(true);
                return field.get(target);
            }
            catch (Exception e) {
                continue;
            }
        }
        throw new NoSuchFieldException("class:" + target.getClass() + ", field:" + fieldName);
    }

    public static Object invokeMethod(Object target, String methodName) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        int i = 0;
        for (Class<?> cl = target.getClass(); i++ < 20 && cl != null; cl = cl.getSuperclass()) {
            try {
                Method m = cl.getDeclaredMethod(methodName, new Class[0]);
                m.setAccessible(true);
                return m.invoke(target, new Object[0]);
            }
            catch (Exception e) {
                continue;
            }
        }
        throw new NoSuchMethodException("class:" + target.getClass() + ", methodName:" + methodName);
    }

    public static Object invokeMethod(Object target, String methodName, Class<?>[] parameterTypes, Object[] args) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        int i = 0;
        for (Class<?> cl = target.getClass(); i++ < 20 && cl != null; cl = cl.getSuperclass()) {
            try {
                Method m = cl.getDeclaredMethod(methodName, parameterTypes);
                m.setAccessible(true);
                return m.invoke(target, args);
            }
            catch (Exception e) {
                continue;
            }
        }
        throw new NoSuchMethodException("class:" + target.getClass() + ", methodName:" + methodName);
    }

    public static Object invokeStaticMethod(Class<?> targetClass, String methodName, Class<?>[] parameterTypes, Object[] parameterValues) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        int i = 0;
        while (i++ < 20 && targetClass != null) {
            try {
                Method m = targetClass.getMethod(methodName, parameterTypes);
                return m.invoke(null, parameterValues);
            }
            catch (Exception e) {
                targetClass = targetClass.getSuperclass();
            }
        }
        throw new NoSuchMethodException("class:" + targetClass + ", methodName:" + methodName);
    }

    public static Method getMethod(Class<?> classType, String methodName, Class<?>[] parameterTypes) throws NoSuchMethodException, SecurityException {
        return classType.getMethod(methodName, parameterTypes);
    }

    public static Set<Class<?>> getInterfaces(Class<?> clazz) {
        if (clazz.isInterface()) {
            return Collections.singleton(clazz);
        }
        LinkedHashSet interfaces = new LinkedHashSet();
        while (clazz != null) {
            Class<?>[] ifcs;
            for (Class<?> ifc : ifcs = clazz.getInterfaces()) {
                interfaces.addAll(ReflectionUtil.getInterfaces(ifc));
            }
            clazz = clazz.getSuperclass();
        }
        return interfaces;
    }

    public static void modifyStaticFinalField(Class cla, String modifyFieldName, Object newValue) throws NoSuchFieldException, IllegalAccessException {
        Field field = cla.getDeclaredField(modifyFieldName);
        field.setAccessible(true);
        Field modifiers = field.getClass().getDeclaredField("modifiers");
        modifiers.setAccessible(true);
        modifiers.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        field.set(cla, newValue);
    }
}

