/*
 * Decompiled with CFR 0.152.
 */
package io.seata.core.store;

public enum StoreMode {
    FILE("file"),
    DB("db"),
    REDIS("redis");

    private String name;

    private StoreMode(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static StoreMode get(String name) {
        for (StoreMode sm : (StoreMode[])StoreMode.class.getEnumConstants()) {
            if (!sm.name.equalsIgnoreCase(name)) continue;
            return sm;
        }
        throw new IllegalArgumentException("unknown store mode:" + name);
    }

    public static boolean contains(String name) {
        try {
            return StoreMode.get(name) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

