/*
 * Decompiled with CFR 0.152.
 */
package io.seata.metrics.registry;

import io.seata.common.exception.NotSupportYetException;
import io.seata.common.loader.EnhancedServiceLoader;
import io.seata.common.util.StringUtils;
import io.seata.config.ConfigurationFactory;
import io.seata.metrics.registry.Registry;
import io.seata.metrics.registry.RegistryType;
import java.util.Objects;

public class RegistryFactory {
    public static Registry getInstance() {
        String registryTypeName = ConfigurationFactory.getInstance().getConfig("metrics.registryType", "compact");
        if (!StringUtils.isNullOrEmpty((String)registryTypeName)) {
            RegistryType registryType;
            try {
                registryType = RegistryType.getType(registryTypeName);
            }
            catch (Exception exx) {
                throw new NotSupportYetException("not support metrics registry type: " + registryTypeName);
            }
            return (Registry)EnhancedServiceLoader.load(Registry.class, (String)Objects.requireNonNull(registryType).getName());
        }
        return null;
    }
}

