/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource;

import io.seata.common.util.CollectionUtils;
import io.seata.common.util.StringUtils;
import io.seata.rm.datasource.undo.KeywordChecker;
import io.seata.rm.datasource.undo.KeywordCheckerFactory;
import java.util.ArrayList;
import java.util.List;

public final class ColumnUtils {
    public static List<String> delEscape(List<String> cols, String dbType) {
        List<String> newCols = ColumnUtils.delEscape(cols, Escape.STANDARD);
        if (ColumnUtils.isMysqlSeries(dbType)) {
            newCols = ColumnUtils.delEscape(newCols, Escape.MYSQL);
        }
        return newCols;
    }

    public static List<String> delEscape(List<String> cols, Escape escape) {
        if (CollectionUtils.isEmpty(cols)) {
            return cols;
        }
        ArrayList<String> newCols = new ArrayList<String>(cols.size());
        int len = cols.size();
        for (int i = 0; i < len; ++i) {
            String col = cols.get(i);
            col = ColumnUtils.delEscape(col, escape);
            newCols.add(col);
        }
        return newCols;
    }

    public static String delEscape(String colName, String dbType) {
        String newColName = ColumnUtils.delEscape(colName, Escape.STANDARD);
        if (ColumnUtils.isMysqlSeries(dbType)) {
            newColName = ColumnUtils.delEscape(newColName, Escape.MYSQL);
        }
        return newColName;
    }

    public static String delEscape(String colName, Escape escape) {
        if (colName == null || colName.isEmpty()) {
            return colName;
        }
        if (colName.charAt(0) == escape.value && colName.charAt(colName.length() - 1) == escape.value) {
            return colName.substring(1, colName.length() - 1);
        }
        return colName;
    }

    public static List<String> addEscape(List<String> cols, String dbType) {
        if (CollectionUtils.isEmpty(cols)) {
            return cols;
        }
        ArrayList<String> newCols = new ArrayList<String>(cols.size());
        int len = cols.size();
        for (int i = 0; i < len; ++i) {
            String col = cols.get(i);
            col = ColumnUtils.addEscape(col, dbType);
            newCols.add(col);
        }
        return newCols;
    }

    public static String addEscape(String colName, String dbType) {
        if (ColumnUtils.isMysqlSeries(dbType)) {
            return ColumnUtils.addEscape(colName, dbType, Escape.MYSQL);
        }
        return ColumnUtils.addEscape(colName, dbType, Escape.STANDARD);
    }

    private static String addEscape(String colName, String dbType, Escape escape) {
        boolean check;
        if (colName == null || colName.isEmpty()) {
            return colName;
        }
        if (colName.charAt(0) == escape.value && colName.charAt(colName.length() - 1) == escape.value) {
            return colName;
        }
        KeywordChecker keywordChecker = KeywordCheckerFactory.getKeywordChecker(dbType);
        if (keywordChecker != null && !(check = keywordChecker.checkEscape(colName))) {
            return colName;
        }
        StringBuilder result = new StringBuilder(2 * String.valueOf(escape.value).length() + colName.length());
        return result.append(escape.value).append(colName).append(escape.value).toString();
    }

    private static boolean isMysqlSeries(String dbType) {
        return StringUtils.equalsIgnoreCase((String)dbType, (String)"mysql") || StringUtils.equalsIgnoreCase((String)dbType, (String)"h2") || StringUtils.equalsIgnoreCase((String)dbType, (String)"mariadb");
    }

    public static enum Escape {
        STANDARD('\"'),
        MYSQL('`');

        public final char value;

        private Escape(char value) {
            this.value = value;
        }
    }
}

