/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.undo;

import io.seata.common.loader.EnhancedServiceLoader;
import io.seata.rm.datasource.undo.KeywordChecker;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class KeywordCheckerFactory {
    private static final Map<String, KeywordChecker> KEYWORD_CHECKER_MAP = new ConcurrentHashMap<String, KeywordChecker>();

    public static KeywordChecker getKeywordChecker(String dbType) {
        if (KEYWORD_CHECKER_MAP.get(dbType) != null) {
            return KEYWORD_CHECKER_MAP.get(dbType);
        }
        KeywordChecker tableMetaCache = (KeywordChecker)EnhancedServiceLoader.load(KeywordChecker.class, (String)dbType);
        KEYWORD_CHECKER_MAP.putIfAbsent(dbType, tableMetaCache);
        return tableMetaCache;
    }
}

