/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.exec;

import io.seata.common.exception.NotSupportYetException;
import io.seata.common.util.CollectionUtils;
import io.seata.rm.datasource.ConnectionContext;
import io.seata.rm.datasource.ConnectionProxy;
import io.seata.rm.datasource.StatementProxy;
import io.seata.rm.datasource.exec.BaseTransactionalExecutor;
import io.seata.rm.datasource.exec.StatementCallback;
import io.seata.rm.datasource.sql.struct.TableRecords;
import io.seata.sqlparser.SQLRecognizer;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDMLBaseExecutor<T, S extends Statement>
extends BaseTransactionalExecutor<T, S> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDMLBaseExecutor.class);
    protected static final String WHERE = " WHERE ";

    public AbstractDMLBaseExecutor(StatementProxy<S> statementProxy, StatementCallback<T, S> statementCallback, SQLRecognizer sqlRecognizer) {
        super(statementProxy, statementCallback, sqlRecognizer);
    }

    public AbstractDMLBaseExecutor(StatementProxy<S> statementProxy, StatementCallback<T, S> statementCallback, List<SQLRecognizer> sqlRecognizers) {
        super(statementProxy, statementCallback, sqlRecognizers);
    }

    @Override
    public T doExecute(Object ... args) throws Throwable {
        ConnectionProxy connectionProxy = this.statementProxy.getConnectionProxy();
        if (connectionProxy.getAutoCommit()) {
            return this.executeAutoCommitTrue(args);
        }
        return this.executeAutoCommitFalse(args);
    }

    protected T executeAutoCommitFalse(Object[] args) throws Exception {
        if (!"mysql".equalsIgnoreCase(this.getDbType()) && this.isMultiPk()) {
            throw new NotSupportYetException("multi pk only support mysql!");
        }
        TableRecords beforeImage = this.beforeImage();
        Object result = this.statementCallback.execute(this.statementProxy.getTargetStatement(), args);
        TableRecords afterImage = this.afterImage(beforeImage);
        this.prepareUndoLog(beforeImage, afterImage);
        return result;
    }

    private boolean isMultiPk() {
        if (null != this.sqlRecognizer) {
            return this.getTableMeta().getPrimaryKeyOnlyName().size() > 1;
        }
        if (CollectionUtils.isNotEmpty((Collection)this.sqlRecognizers)) {
            List distinctSQLRecognizer = this.sqlRecognizers.stream().filter(AbstractDMLBaseExecutor.distinctByKey(t -> t.getTableName())).collect(Collectors.toList());
            for (SQLRecognizer sqlRecognizer : distinctSQLRecognizer) {
                if (this.getTableMeta(sqlRecognizer.getTableName()).getPrimaryKeyOnlyName().size() <= 1) continue;
                return true;
            }
        }
        return false;
    }

    private static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        HashMap map = new HashMap();
        return t -> map.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }

    protected T executeAutoCommitTrue(Object[] args) throws Throwable {
        ConnectionProxy connectionProxy = this.statementProxy.getConnectionProxy();
        try {
            connectionProxy.changeAutoCommit();
            Object object = new LockRetryPolicy(connectionProxy).execute(() -> {
                T result = this.executeAutoCommitFalse(args);
                connectionProxy.commit();
                return result;
            });
            return (T)object;
        }
        catch (Exception e) {
            LOGGER.error("execute executeAutoCommitTrue error:{}", (Object)e.getMessage(), (Object)e);
            if (!LockRetryPolicy.isLockRetryPolicyBranchRollbackOnConflict()) {
                connectionProxy.getTargetConnection().rollback();
            }
            throw e;
        }
        finally {
            connectionProxy.getContext().reset();
            connectionProxy.setAutoCommit(true);
        }
    }

    protected abstract TableRecords beforeImage() throws SQLException;

    protected abstract TableRecords afterImage(TableRecords var1) throws SQLException;

    private static class LockRetryPolicy
    extends ConnectionProxy.LockRetryPolicy {
        private final ConnectionProxy connection;

        LockRetryPolicy(ConnectionProxy connection) {
            this.connection = connection;
        }

        @Override
        public <T> T execute(Callable<T> callable) throws Exception {
            if (LOCK_RETRY_POLICY_BRANCH_ROLLBACK_ON_CONFLICT) {
                return this.doRetryOnLockConflict(callable);
            }
            return callable.call();
        }

        @Override
        protected void onException(Exception e) throws Exception {
            ConnectionContext context = this.connection.getContext();
            context.removeSavepoint(null);
            this.connection.getTargetConnection().rollback();
        }

        public static boolean isLockRetryPolicyBranchRollbackOnConflict() {
            return LOCK_RETRY_POLICY_BRANCH_ROLLBACK_ON_CONFLICT;
        }
    }
}

