/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.sql.struct;

import io.seata.common.exception.ShouldNeverHappenException;
import io.seata.rm.datasource.sql.serial.SerialArray;
import io.seata.rm.datasource.sql.struct.ColumnMeta;
import io.seata.rm.datasource.sql.struct.Field;
import io.seata.rm.datasource.sql.struct.KeyType;
import io.seata.rm.datasource.sql.struct.Row;
import io.seata.rm.datasource.sql.struct.TableMeta;
import java.io.Serializable;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialClob;
import javax.sql.rowset.serial.SerialDatalink;
import javax.sql.rowset.serial.SerialJavaObject;
import javax.sql.rowset.serial.SerialRef;

public class TableRecords
implements Serializable {
    private static final long serialVersionUID = 4441667803166771721L;
    private transient TableMeta tableMeta;
    private String tableName;
    private List<Row> rows = new ArrayList<Row>();

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public List<Row> getRows() {
        return this.rows;
    }

    public void setRows(List<Row> rows) {
        this.rows = rows;
    }

    public TableRecords() {
    }

    public TableRecords(TableMeta tableMeta) {
        this.setTableMeta(tableMeta);
    }

    public void setTableMeta(TableMeta tableMeta) {
        if (this.tableMeta != null) {
            throw new ShouldNeverHappenException();
        }
        this.tableMeta = tableMeta;
        this.tableName = tableMeta.getTableName();
    }

    public int size() {
        return this.rows.size();
    }

    public void add(Row row) {
        this.rows.add(row);
    }

    public List<Map<String, Field>> pkRows() {
        Map<String, ColumnMeta> primaryKeyMap = this.getTableMeta().getPrimaryKeyMap();
        ArrayList<Map<String, Field>> pkRows = new ArrayList<Map<String, Field>>();
        for (Row row : this.rows) {
            List<Field> fields = row.getFields();
            HashMap<String, Field> rowMap = new HashMap<String, Field>(3);
            for (Field field : fields) {
                if (!primaryKeyMap.containsKey(field.getName())) continue;
                rowMap.put(field.getName(), field);
            }
            pkRows.add(rowMap);
        }
        return pkRows;
    }

    public TableMeta getTableMeta() {
        return this.tableMeta;
    }

    public static TableRecords empty(TableMeta tableMeta) {
        return new EmptyTableRecords(tableMeta);
    }

    public static TableRecords buildRecords(TableMeta tmeta, ResultSet resultSet) throws SQLException {
        TableRecords records = new TableRecords(tmeta);
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int columnCount = resultSetMetaData.getColumnCount();
        while (resultSet.next()) {
            ArrayList<Field> fields = new ArrayList<Field>(columnCount);
            for (int i = 1; i <= columnCount; ++i) {
                Object object;
                String colName = resultSetMetaData.getColumnName(i);
                ColumnMeta col = tmeta.getColumnMeta(colName);
                int dataType = col.getDataType();
                Field field = new Field();
                field.setName(col.getColumnName());
                if (tmeta.getPrimaryKeyMap().containsKey(colName)) {
                    field.setKeyType(KeyType.PRIMARY_KEY);
                }
                field.setType(dataType);
                if (dataType == 2004) {
                    Blob blob = resultSet.getBlob(i);
                    if (blob != null) {
                        field.setValue(new SerialBlob(blob));
                    }
                } else if (dataType == 2005) {
                    Clob clob = resultSet.getClob(i);
                    if (clob != null) {
                        field.setValue(new SerialClob(clob));
                    }
                } else if (dataType == 2011) {
                    object = resultSet.getNClob(i);
                    if (object != null) {
                        field.setValue(new SerialClob((Clob)object));
                    }
                } else if (dataType == 2003) {
                    Array array = resultSet.getArray(i);
                    if (array != null) {
                        field.setValue(new SerialArray(array));
                    }
                } else if (dataType == 2006) {
                    Ref ref = resultSet.getRef(i);
                    if (ref != null) {
                        field.setValue(new SerialRef(ref));
                    }
                } else if (dataType == 70) {
                    URL url = resultSet.getURL(i);
                    if (url != null) {
                        field.setValue(new SerialDatalink(url));
                    }
                } else if (dataType == 2000) {
                    object = resultSet.getObject(i);
                    if (object != null) {
                        field.setValue(new SerialJavaObject(object));
                    }
                } else {
                    field.setValue(resultSet.getObject(i));
                }
                fields.add(field);
            }
            Row row = new Row();
            row.setFields(fields);
            records.add(row);
        }
        return records;
    }

    public static class EmptyTableRecords
    extends TableRecords {
        public EmptyTableRecords() {
        }

        public EmptyTableRecords(TableMeta tableMeta) {
            this.setTableMeta(tableMeta);
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public List<Map<String, Field>> pkRows() {
            return new ArrayList<Map<String, Field>>();
        }

        @Override
        public void add(Row row) {
            throw new UnsupportedOperationException("xxx");
        }

        @Override
        public TableMeta getTableMeta() {
            throw new UnsupportedOperationException("xxx");
        }
    }
}

