/*
 * Decompiled with CFR 0.152.
 */
package io.seata.server.console.impl.db;

import io.seata.common.exception.StoreException;
import io.seata.common.loader.EnhancedServiceLoader;
import io.seata.common.util.IOUtil;
import io.seata.common.util.PageUtil;
import io.seata.common.util.StringUtils;
import io.seata.config.ConfigurationFactory;
import io.seata.console.result.PageResult;
import io.seata.core.store.db.DataSourceProvider;
import io.seata.core.store.db.sql.lock.LockStoreSqlFactory;
import io.seata.server.console.param.GlobalLockParam;
import io.seata.server.console.service.GlobalLockService;
import io.seata.server.console.vo.GlobalLockVO;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

@Component
@Configuration
@ConditionalOnExpression(value="#{'db'.equals('${lockMode}')}")
public class GlobalLockDBServiceImpl
implements GlobalLockService {
    private String lockTable;
    private String dbType;
    private DataSource dataSource;

    public GlobalLockDBServiceImpl() {
        io.seata.config.Configuration configuration = ConfigurationFactory.getInstance();
        this.lockTable = configuration.getConfig("store.db.lockTable", "lock_table");
        this.dbType = configuration.getConfig("store.db.dbType");
        if (StringUtils.isBlank((String)this.dbType)) {
            throw new IllegalArgumentException("store.db.dbType should not be blank");
        }
        String dbDataSource = configuration.getConfig("store.db.datasource");
        if (StringUtils.isBlank((String)dbDataSource)) {
            throw new IllegalArgumentException("store.db.datasource should not be blank");
        }
        this.dataSource = ((DataSourceProvider)EnhancedServiceLoader.load(DataSourceProvider.class, (String)dbDataSource)).provide();
    }

    @Override
    public PageResult<GlobalLockVO> query(GlobalLockParam param) {
        PageUtil.checkParam((int)param.getPageNum(), (int)param.getPageSize());
        ArrayList<Object> sqlParamList = new ArrayList<Object>();
        String whereCondition = this.getWhereConditionByParam(param, sqlParamList);
        String sourceSql = LockStoreSqlFactory.getLogStoreSql((String)this.dbType).getAllLockSql(this.lockTable, whereCondition);
        String queryLockSql = PageUtil.pageSql((String)sourceSql, (String)this.dbType, (int)param.getPageNum(), (int)param.getPageSize());
        String lockCountSql = PageUtil.countSql((String)sourceSql, (String)this.dbType);
        ArrayList<GlobalLockVO> list = new ArrayList<GlobalLockVO>();
        int count = 0;
        ResultSet rs = null;
        ResultSet countRs = null;
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement ps = conn.prepareStatement(queryLockSql);
             PreparedStatement countPs = conn.prepareStatement(lockCountSql);){
            PageUtil.setObject((PreparedStatement)ps, sqlParamList);
            rs = ps.executeQuery();
            while (rs.next()) {
                list.add(GlobalLockVO.convert(rs));
            }
            PageUtil.setObject((PreparedStatement)countPs, sqlParamList);
            countRs = countPs.executeQuery();
            if (countRs.next()) {
                count = countRs.getInt(1);
            }
        }
        catch (SQLException e) {
            try {
                throw new StoreException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtil.close((AutoCloseable[])new AutoCloseable[]{rs, countRs});
                throw throwable;
            }
        }
        IOUtil.close((AutoCloseable[])new AutoCloseable[]{rs, countRs});
        return PageResult.success(list, (Integer)count, (Integer)param.getPageNum(), (Integer)param.getPageSize());
    }

    private String getWhereConditionByParam(GlobalLockParam param, List<Object> sqlParamList) {
        StringBuilder whereConditionBuilder = new StringBuilder();
        if (StringUtils.isNotBlank((String)param.getXid())) {
            whereConditionBuilder.append(" and xid = ? ");
            sqlParamList.add(param.getXid());
        }
        if (StringUtils.isNotBlank((String)param.getTableName())) {
            whereConditionBuilder.append(" and table_name = ? ");
            sqlParamList.add(param.getTableName());
        }
        if (StringUtils.isNotBlank((String)param.getTransactionId())) {
            whereConditionBuilder.append(" and transaction_id = ? ");
            sqlParamList.add(param.getTransactionId());
        }
        if (StringUtils.isNotBlank((String)param.getBranchId())) {
            whereConditionBuilder.append(" and branch_id = ? ");
            sqlParamList.add(param.getBranchId());
        }
        if (param.getTimeStart() != null) {
            whereConditionBuilder.append(" and gmt_create >= ? ");
            sqlParamList.add(param.getTimeStart());
        }
        if (param.getTimeEnd() != null) {
            whereConditionBuilder.append(" and gmt_create <= ? ");
            sqlParamList.add(param.getTimeEnd());
        }
        String whereCondition = whereConditionBuilder.toString();
        return whereCondition.replaceFirst("and", "where");
    }
}

