/*
 * Decompiled with CFR 0.152.
 */
package io.seata.server.console.impl.file;

import io.seata.common.util.StringUtils;
import io.seata.console.result.PageResult;
import io.seata.server.console.param.GlobalSessionParam;
import io.seata.server.console.service.GlobalSessionService;
import io.seata.server.console.vo.GlobalSessionVO;
import io.seata.server.session.GlobalSession;
import io.seata.server.session.SessionHolder;
import io.seata.server.storage.SessionConverter;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

@Component
@Configuration
@ConditionalOnExpression(value="#{'file'.equals('${sessionMode}')}")
public class GlobalSessionFileServiceImpl
implements GlobalSessionService {
    @Override
    public PageResult<GlobalSessionVO> query(GlobalSessionParam param) {
        if (param.getPageSize() <= 0 || param.getPageNum() <= 0) {
            throw new IllegalArgumentException("wrong pageSize or pageNum");
        }
        Collection<GlobalSession> allSessions = SessionHolder.getRootSessionManager().allSessions();
        List<GlobalSession> filteredSessions = allSessions.parallelStream().filter(this.obtainPredicate(param)).collect(Collectors.toList());
        return PageResult.build(SessionConverter.convertGlobalSession(filteredSessions), (Integer)param.getPageNum(), (Integer)param.getPageSize());
    }

    private Predicate<? super GlobalSession> obtainPredicate(GlobalSessionParam param) {
        return session -> !(!StringUtils.isBlank((String)param.getXid()) && !session.getXid().contains(param.getXid()) || !StringUtils.isBlank((String)param.getApplicationId()) && !session.getApplicationId().contains(param.getApplicationId()) || !Objects.isNull(param.getStatus()) && !Objects.equals(session.getStatus().getCode(), param.getStatus()) || !StringUtils.isBlank((String)param.getTransactionName()) && !session.getTransactionName().contains(param.getTransactionName()) || !Objects.isNull(param.getTimeStart()) && param.getTimeStart() > session.getBeginTime() || !Objects.isNull(param.getTimeEnd()) && param.getTimeEnd() < session.getBeginTime());
    }
}

