/*
 * Decompiled with CFR 0.152.
 */
package io.seata.server.metrics;

import io.seata.core.event.Event;
import io.seata.core.event.EventBus;
import io.seata.core.event.GlobalTransactionEvent;
import io.seata.core.model.GlobalStatus;
import io.seata.server.event.EventBusManager;
import io.seata.server.session.GlobalSession;

public class MetricsPublisher {
    private static final EventBus EVENT_BUS = EventBusManager.get();

    public static void postSessionDoneEvent(GlobalSession globalSession, boolean retryGlobal, boolean retryBranch) {
        MetricsPublisher.postSessionDoneEvent(globalSession, globalSession.getStatus(), retryGlobal, retryBranch);
    }

    public static void postSessionDoneEvent(GlobalSession globalSession, GlobalStatus status, boolean retryGlobal, boolean retryBranch) {
        MetricsPublisher.postSessionDoneEvent(globalSession, status.name(), retryGlobal, globalSession.getBeginTime(), retryBranch);
    }

    public static void postSessionDoneEvent(GlobalSession globalSession, String status, boolean retryGlobal, long beginTime, boolean retryBranch) {
        EVENT_BUS.post((Event)new GlobalTransactionEvent(globalSession.getTransactionId(), "tc", globalSession.getTransactionName(), globalSession.getApplicationId(), globalSession.getTransactionServiceGroup(), Long.valueOf(beginTime), Long.valueOf(System.currentTimeMillis()), status, retryGlobal, retryBranch));
    }

    public static void postSessionDoingEvent(GlobalSession globalSession, boolean retryGlobal) {
        MetricsPublisher.postSessionDoingEvent(globalSession, globalSession.getStatus().name(), retryGlobal, false);
    }

    public static void postSessionDoingEvent(GlobalSession globalSession, String status, boolean retryGlobal, boolean retryBranch) {
        EVENT_BUS.post((Event)new GlobalTransactionEvent(globalSession.getTransactionId(), "tc", globalSession.getTransactionName(), globalSession.getApplicationId(), globalSession.getTransactionServiceGroup(), Long.valueOf(globalSession.getBeginTime()), null, status, retryGlobal, retryBranch));
    }
}

