/*
 * Decompiled with CFR 0.152.
 */
package io.seata.server.storage.redis.lock;

import com.google.common.collect.Lists;
import io.seata.common.exception.StoreException;
import io.seata.common.io.FileLoader;
import io.seata.common.util.CollectionUtils;
import io.seata.common.util.LambdaUtils;
import io.seata.common.util.StringUtils;
import io.seata.core.exception.BranchTransactionException;
import io.seata.core.exception.TransactionExceptionCode;
import io.seata.core.lock.AbstractLocker;
import io.seata.core.lock.RowLock;
import io.seata.core.model.LockStatus;
import io.seata.core.store.LockDO;
import io.seata.server.storage.redis.JedisPooledFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Pipeline;

public class RedisLocker
extends AbstractLocker {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisLocker.class);
    private static final Integer SUCCEED = 1;
    private static final Integer FAILED = 0;
    private static final String XID = "xid";
    private static final String TRANSACTION_ID = "transactionId";
    private static final String BRANCH_ID = "branchId";
    private static final String RESOURCE_ID = "resourceId";
    private static final String TABLE_NAME = "tableName";
    private static final String PK = "pk";
    private static final String STATUS = "status";
    private static final String ROW_KEY = "rowKey";
    private static final String REDIS_LUA_FILE_NAME = "lua/redislocker/redislock.lua";
    private static String ACQUIRE_LOCK_SHA;
    private static final String WHITE_SPACE = " ";
    private static final String ANNOTATION_LUA = "--";

    public RedisLocker() {
        if (ACQUIRE_LOCK_SHA == null) {
            File luaFile = FileLoader.load((String)REDIS_LUA_FILE_NAME);
            if (luaFile != null) {
                Throwable throwable;
                StringBuilder acquireLockLuaByFile = new StringBuilder();
                try {
                    throwable = null;
                    try (FileInputStream fis = new FileInputStream(luaFile);){
                        String line;
                        BufferedReader br = new BufferedReader(new InputStreamReader(fis));
                        while ((line = br.readLine()) != null) {
                            if (line.trim().startsWith(ANNOTATION_LUA)) continue;
                            acquireLockLuaByFile.append(line);
                            acquireLockLuaByFile.append(WHITE_SPACE);
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (IOException e) {
                    LOGGER.info("redis locker use pipeline mode");
                    return;
                }
                throwable = null;
                try (Jedis jedis = JedisPooledFactory.getJedisInstance();){
                    ACQUIRE_LOCK_SHA = jedis.scriptLoad(acquireLockLuaByFile.toString());
                    LOGGER.info("redis locker use lua mode");
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            LOGGER.info("redis locker use pipeline mode");
        }
    }

    public boolean acquireLock(List<RowLock> rowLocks) {
        return this.acquireLock(rowLocks, true, false);
    }

    public boolean acquireLock(List<RowLock> rowLocks, boolean autoCommit, boolean skipCheckLock) {
        if (CollectionUtils.isEmpty(rowLocks)) {
            return true;
        }
        try (Jedis jedis = JedisPooledFactory.getJedisInstance();){
            if (ACQUIRE_LOCK_SHA != null && autoCommit) {
                boolean bl = this.acquireLockByLua(jedis, rowLocks);
                return bl;
            }
            boolean bl = this.acquireLockByPipeline(jedis, rowLocks, autoCommit, skipCheckLock);
            return bl;
        }
    }

    private boolean acquireLockByPipeline(Jedis jedis, List<RowLock> rowLocks, boolean autoCommit, boolean skipCheckLock) {
        String needLockXid = rowLocks.get(0).getXid();
        Long branchId = rowLocks.get(0).getBranchId();
        List<LockDO> needLockDOS = this.convertToLockDO(rowLocks);
        if (needLockDOS.size() > 1) {
            needLockDOS = needLockDOS.stream().filter(LambdaUtils.distinctByKey(LockDO::getRowKey)).collect(Collectors.toList());
        }
        ArrayList needLockKeys = new ArrayList();
        needLockDOS.forEach(lockDO -> needLockKeys.add(this.buildLockKey(lockDO.getRowKey())));
        HashMap<Object, Object> needAddLock = new HashMap<Object, Object>(needLockKeys.size(), 1.0f);
        if (!skipCheckLock) {
            boolean hasRollBackingLock;
            Pipeline pipeline1 = jedis.pipelined();
            needLockKeys.stream().forEachOrdered(needLockKey -> {
                pipeline1.hget(needLockKey, XID);
                if (!autoCommit) {
                    pipeline1.hget(needLockKey, STATUS);
                }
            });
            List existedLockInfos = Lists.partition((List)pipeline1.syncAndReturnAll(), (int)(autoCommit ? 1 : 2));
            if (!autoCommit && (hasRollBackingLock = existedLockInfos.parallelStream().anyMatch(result -> StringUtils.equals((String)((String)result.get(1)), (String)String.valueOf(LockStatus.Rollbacking.getCode()))))) {
                throw new StoreException((Throwable)new BranchTransactionException(TransactionExceptionCode.LockKeyConflictFailFast));
            }
            for (int i = 0; i < needLockKeys.size(); ++i) {
                String existedLockXid;
                List results = (List)existedLockInfos.get(i);
                String string = existedLockXid = CollectionUtils.isEmpty((Collection)results) ? null : (String)((List)existedLockInfos.get(i)).get(0);
                if (StringUtils.isEmpty(existedLockXid)) {
                    needAddLock.put(needLockKeys.get(i), needLockDOS.get(i));
                    continue;
                }
                if (StringUtils.equals((String)existedLockXid, (String)needLockXid)) continue;
                this.logGlobalLockConflictInfo(needLockXid, (String)needLockKeys.get(i), existedLockXid);
                return false;
            }
            if (needAddLock.isEmpty()) {
                return true;
            }
        }
        Pipeline pipeline = jedis.pipelined();
        ArrayList readyKeys = new ArrayList(needAddLock.keySet());
        needAddLock.forEach((key, value) -> {
            pipeline.hsetnx(key, XID, value.getXid());
            pipeline.hsetnx(key, TRANSACTION_ID, value.getTransactionId().toString());
            pipeline.hsetnx(key, BRANCH_ID, value.getBranchId().toString());
            pipeline.hset(key, ROW_KEY, value.getRowKey());
            pipeline.hset(key, RESOURCE_ID, value.getResourceId());
            pipeline.hset(key, TABLE_NAME, value.getTableName());
            pipeline.hset(key, PK, value.getPk());
        });
        List results = pipeline.syncAndReturnAll();
        List partitions = Lists.partition((List)results, (int)7);
        ArrayList success = new ArrayList(partitions.size());
        Integer status = SUCCEED;
        for (int i = 0; i < partitions.size(); ++i) {
            if (Objects.equals(((List)partitions.get(i)).get(0), FAILED)) {
                status = FAILED;
                continue;
            }
            success.add(readyKeys.get(i));
        }
        if (FAILED.equals(status)) {
            if (success.size() > 0) {
                jedis.del(success.toArray(new String[0]));
            }
            return false;
        }
        String xidLockKey = this.buildXidLockKey(needLockXid);
        StringJoiner lockKeysString = new StringJoiner(";");
        needLockKeys.forEach(lockKeysString::add);
        jedis.hset(xidLockKey, branchId.toString(), lockKeysString.toString());
        return true;
    }

    private boolean acquireLockByLua(Jedis jedis, List<RowLock> rowLocks) {
        String needLockXid = rowLocks.get(0).getXid();
        Long branchId = rowLocks.get(0).getBranchId();
        List needLockDOs = rowLocks.stream().map(arg_0 -> ((RedisLocker)this).convertToLockDO(arg_0)).filter(LambdaUtils.distinctByKey(LockDO::getRowKey)).collect(Collectors.toList());
        ArrayList<String> keys = new ArrayList<String>();
        ArrayList<String> args = new ArrayList<String>();
        int size = needLockDOs.size();
        args.add(String.valueOf(size));
        args.add(null);
        args.add(needLockXid);
        for (LockDO lockDO2 : needLockDOs) {
            keys.add(this.buildLockKey(lockDO2.getRowKey()));
            args.add(lockDO2.getTransactionId().toString());
            args.add(lockDO2.getBranchId().toString());
            args.add(lockDO2.getResourceId());
            args.add(lockDO2.getTableName());
            args.add(lockDO2.getRowKey());
            args.add(lockDO2.getPk());
        }
        String xidLockKey = this.buildXidLockKey(needLockXid);
        StringJoiner lockKeysString = new StringJoiner(";");
        needLockDOs.stream().map(lockDO -> this.buildLockKey(lockDO.getRowKey())).forEach(lockKeysString::add);
        keys.add(xidLockKey);
        keys.add(branchId.toString());
        args.add(lockKeysString.toString());
        args.set(1, String.valueOf(args.size()));
        String xIdOwnLock = (String)jedis.evalsha(ACQUIRE_LOCK_SHA, keys, args);
        if (xIdOwnLock.equals(needLockXid)) {
            return true;
        }
        this.logGlobalLockConflictInfo(needLockXid, (String)keys.get(0), xIdOwnLock);
        return false;
    }

    private void logGlobalLockConflictInfo(String needLockXid, String lockKey, String xIdOwnLock) {
        LOGGER.info("tx:[{}] acquire Global lock failed. Global lock on [{}] is holding by xid {}", new Object[]{needLockXid, lockKey, xIdOwnLock});
    }

    /*
     * Exception decompiling
     */
    public boolean releaseLock(List<RowLock> rowLocks) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean releaseLock(String xid) {
        return this.doReleaseLock(xid, null);
    }

    public boolean releaseLock(String xid, Long branchId) {
        if (branchId == null) {
            return true;
        }
        return this.doReleaseLock(xid, branchId);
    }

    /*
     * Exception decompiling
     */
    public boolean isLockable(List<RowLock> rowLocks) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void updateLockStatus(String xid, LockStatus lockStatus) {
        block24: {
            try (Jedis jedis = JedisPooledFactory.getJedisInstance();){
                String xidLockKey = this.buildXidLockKey(xid);
                Map branchAndLockKeys = jedis.hgetAll(xidLockKey);
                if (!CollectionUtils.isNotEmpty((Map)branchAndLockKeys)) break block24;
                try (Pipeline pipeline = jedis.pipelined();){
                    branchAndLockKeys.values().forEach(k -> pipeline.hset(k, STATUS, String.valueOf(lockStatus.getCode())));
                    pipeline.sync();
                }
            }
        }
    }

    private boolean doReleaseLock(String xid, Long branchId) {
        try (Jedis jedis = JedisPooledFactory.getJedisInstance();){
            String xidLockKey = this.buildXidLockKey(xid);
            ArrayList<String> rowKeys = new ArrayList<String>();
            if (null == branchId) {
                Map rowKeyMap = jedis.hgetAll(xidLockKey);
                rowKeyMap.forEach((branch, rowKey) -> rowKeys.add((String)rowKey));
            } else {
                rowKeys.add(jedis.hget(xidLockKey, branchId.toString()));
            }
            if (CollectionUtils.isNotEmpty(rowKeys)) {
                Pipeline pipelined = jedis.pipelined();
                if (null == branchId) {
                    pipelined.del(xidLockKey);
                } else {
                    pipelined.hdel(xidLockKey, new String[]{branchId.toString()});
                }
                rowKeys.forEach(rowKeyStr -> {
                    if (StringUtils.isNotEmpty((CharSequence)rowKeyStr)) {
                        if (rowKeyStr.contains(";")) {
                            String[] keys = rowKeyStr.split(";");
                            pipelined.del(keys);
                        } else {
                            pipelined.del(rowKeyStr);
                        }
                    }
                });
                pipelined.sync();
            }
            boolean bl = true;
            return bl;
        }
    }

    private String buildXidLockKey(String xid) {
        return "SEATA_GLOBAL_LOCK" + xid;
    }

    private String buildLockKey(String rowKey) {
        return "SEATA_ROW_LOCK_" + rowKey;
    }

    private static /* synthetic */ boolean lambda$isLockable$6(String xid, String existedXid) {
        return existedXid == null || xid.equals(existedXid);
    }

    private static /* synthetic */ void lambda$isLockable$5(Pipeline pipeline, String key) {
        pipeline.hget(key, XID);
    }
}

