/*
 * Decompiled with CFR 0.152.
 */
package io.seata.spring.boot.autoconfigure.provider;

import io.seata.common.exception.ShouldNeverHappenException;
import io.seata.common.holder.ObjectHolder;
import io.seata.common.util.StringUtils;
import io.seata.config.Configuration;
import io.seata.config.ExtConfigurationProvider;
import io.seata.spring.boot.autoconfigure.StarterConstants;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.core.env.ConfigurableEnvironment;

public class SpringBootConfigurationProvider
implements ExtConfigurationProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringBootConfigurationProvider.class);
    private static final String INTERCEPT_METHOD_PREFIX = "get";
    private static final Map<String, Object> PROPERTY_BEAN_INSTANCE_MAP = new HashMap<String, Object>(64);

    public Configuration provide(Configuration originalConfiguration) {
        return (Configuration)Enhancer.create(originalConfiguration.getClass(), (Callback)((MethodInterceptor)(proxy, method, args, methodProxy) -> {
            if (method.getName().startsWith(INTERCEPT_METHOD_PREFIX) && args.length > 0) {
                String rawDataId = (String)args[0];
                Object result = originalConfiguration.getConfigFromSys(rawDataId);
                if (null == result) {
                    result = args.length == 1 ? this.get(this.convertDataId(rawDataId)) : this.get(this.convertDataId(rawDataId), args[1]);
                }
                if (result != null) {
                    if (method.getReturnType().equals(String.class)) {
                        return String.valueOf(result);
                    }
                    return result;
                }
            }
            return method.invoke((Object)originalConfiguration, args);
        }));
    }

    private Object get(String dataId, Object defaultValue) throws IllegalAccessException, InstantiationException {
        Object result = this.get(dataId);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    private Object get(String dataId) throws IllegalAccessException {
        String propertyPrefix = this.getPropertyPrefix(dataId);
        String propertySuffix = this.getPropertySuffix(dataId);
        Class<?> propertyClass = StarterConstants.PROPERTY_BEAN_MAP.get(propertyPrefix);
        Object valueObject = null;
        if (propertyClass != null) {
            try {
                valueObject = this.getFieldValue(Objects.requireNonNull(PROPERTY_BEAN_INSTANCE_MAP.computeIfAbsent(propertyPrefix, k -> {
                    try {
                        return propertyClass.newInstance();
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        LOGGER.error("PropertyClass for prefix: [" + propertyPrefix + "] should not be null. error :" + e.getMessage(), (Throwable)e);
                        return null;
                    }
                })), propertySuffix, dataId);
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {}
        } else {
            throw new ShouldNeverHappenException("PropertyClass for prefix: [" + propertyPrefix + "] should not be null.");
        }
        return valueObject;
    }

    private Object getFieldValue(Object object, String fieldName, String dataId) throws IllegalAccessException {
        Optional<Field> fieldOptional = Stream.of(object.getClass().getDeclaredFields()).filter(f -> f.getName().equalsIgnoreCase(fieldName)).findAny();
        if (fieldOptional.isPresent()) {
            Field field = fieldOptional.get();
            if (Objects.equals(field.getType(), Map.class)) {
                return this.getConfig(dataId, null, String.class);
            }
            field.setAccessible(true);
            Object defaultValue = field.get(object);
            return this.getConfig(dataId, defaultValue, field.getType());
        }
        return null;
    }

    private String convertDataId(String rawDataId) {
        if (rawDataId.endsWith("grouplist")) {
            String suffix = org.apache.commons.lang.StringUtils.removeStart((String)org.apache.commons.lang.StringUtils.removeEnd((String)rawDataId, (String)".grouplist"), (String)"service.");
            return "seata.service.grouplist." + suffix;
        }
        return "seata." + rawDataId;
    }

    private String getPropertyPrefix(String dataId) {
        if (dataId.contains("vgroupMapping")) {
            return "seata.service";
        }
        if (dataId.contains("grouplist")) {
            return "seata.service";
        }
        return org.apache.commons.lang.StringUtils.substringBeforeLast((String)dataId, (String)String.valueOf('.'));
    }

    private String getPropertySuffix(String dataId) {
        if (dataId.contains("vgroupMapping")) {
            return "vgroupMapping";
        }
        if (dataId.contains("grouplist")) {
            return "grouplist";
        }
        return org.apache.commons.lang.StringUtils.substringAfterLast((String)dataId, (String)String.valueOf('.'));
    }

    private Object getConfig(String dataId, Object defaultValue, Class<?> type) {
        ConfigurableEnvironment environment = (ConfigurableEnvironment)ObjectHolder.INSTANCE.getObject("springConfigurableEnvironment");
        Object value = environment.getProperty(dataId, type);
        if (value == null) {
            value = environment.getProperty(StringUtils.hump2Line((String)dataId), type);
        }
        return value != null ? value : defaultValue;
    }
}

